/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.network.endpoints;

import com.voxeet.sdk.events.restapi.ConferenceStatusResult;
import com.voxeet.sdk.events.restapi.ReplayConferenceResult;
import com.voxeet.sdk.events.restapi.ResumeConference;
import com.voxeet.sdk.json.BroadcastEvent;
import com.voxeet.sdk.json.CreateConferenceParams;
import com.voxeet.sdk.json.JoinParameters;
import com.voxeet.sdk.json.SdkConferenceInvitation;
import com.voxeet.sdk.json.SdkConferenceReplayBody;
import com.voxeet.sdk.json.StartScreenSharingResponse;
import com.voxeet.sdk.json.StartVideoResponse;
import com.voxeet.sdk.json.StopScreenSharingResponse;
import com.voxeet.sdk.json.StopVideoResponse;
import com.voxeet.sdk.media.peer.SdpDescription;
import com.voxeet.sdk.models.v1.CandidatesPush;
import com.voxeet.sdk.models.v1.CreateConferenceResult;
import com.voxeet.sdk.models.v1.HistoryConference;
import com.voxeet.sdk.models.v1.SubscribeConference;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface ISdkConferenceRService {
    @POST(value="v1/conferences/create")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Call<CreateConferenceResult> createConference(@Body CreateConferenceParams var1);

    @GET(value="v1/conferences/demo")
    public Call<CreateConferenceResult> createDemo();

    @POST(value="v1/conferences/{id}/replay")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Call<ReplayConferenceResult> replay(@Path(value="id") String var1, @Body SdkConferenceReplayBody var2);

    @GET(value="v1/conferences/{id}/recording/stop")
    public Call<ResponseBody> stopRecording(@Path(value="id") String var1);

    @GET(value="/v1/conferences/{id}/status")
    public Call<ConferenceStatusResult> conferenceStatus(@Path(value="id") String var1);

    @DELETE(value="/v1/conferences/{id}/subscribe")
    public Call<ResponseBody> unSubscribe(@Path(value="id") String var1);

    @GET(value="/v1/conferences/{id}/subscribe")
    public Call<SubscribeConference> subscribe(@Path(value="id") String var1);

    @GET(value="/v1/conferences/{id}/history")
    public Call<List<HistoryConference>> conferenceHistory(@Path(value="id") String var1);

    @GET(value="v1/conferences/{id}/recording/start")
    public Call<ResponseBody> startRecording(@Path(value="id") String var1);

    @POST(value="v1/conferences/{conferenceId}/send")
    public Call<ResponseBody> broadcastMessage(@Path(value="conferenceId") String var1, @Body BroadcastEvent var2);

    @POST(value="v1/conferences/{conferenceId}/join")
    public Call<ResumeConference> joinConference(@Path(value="conferenceId") String var1, @Body JoinParameters var2);

    @POST(value="v1/conferences/{conferenceId}/leave")
    public Call<ResponseBody> leaveConference(@Path(value="conferenceId") String var1);

    @POST(value="v1/conferences/{conferenceId}/answer/{user_id}")
    public Call<ResponseBody> answerConference(@Path(value="conferenceId") String var1, @Path(value="user_id") String var2, @Body SdpDescription var3);

    @POST(value="v1/conferences/{conferenceId}/invite")
    public Call<ResponseBody> invite(@Path(value="conferenceId") String var1, @Body SdkConferenceInvitation var2);

    @GET(value="v1/conferences/{id}/video/{uid}/start")
    public Call<StartVideoResponse> startVideo(@Path(value="id") String var1, @Path(value="uid") String var2);

    @GET(value="v1/conferences/{id}/video/{uid}/stop")
    public Call<StopVideoResponse> stopVideo(@Path(value="id") String var1, @Path(value="uid") String var2);

    @GET(value="v1/conferences/{id}/sharing/start")
    public Call<StartScreenSharingResponse> startScreenShare(@Path(value="id") String var1);

    @GET(value="v1/conferences/{id}/sharing/stop")
    public Call<StopScreenSharingResponse> stopScreenShare(@Path(value="id") String var1);

    @POST(value="v1/conferences/{id}/decline")
    public Call<ResponseBody> decline(@Path(value="id") String var1);

    @GET(value="v1/conferences/{id}/call/subscribe")
    public Call<ResponseBody> subscribeForCall(@Path(value="id") String var1);

    @DELETE(value="v1/conferences/{id}/call/subscribe")
    public Call<ResponseBody> unsubscribeFromCall(@Path(value="id") String var1);

    @POST(value="v1/conferences/{id}/candidates/{peerId}")
    public Call<ResponseBody> candidates(@Path(value="id") String var1, @Path(value="peerId") String var2, @Body CandidatesPush var3);

    @GET(value="v1/conferences/{id}/renegociate")
    public Call<ResponseBody> renegociate(@Path(value="id") String var1);

    @GET(value="v1/conferences/{id}/icerestart")
    public Call<ResponseBody> iceRestart(@Path(value="id") String var1);
}

