/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.media.sensors;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.sdk.media.sensors.ConferenceLock;

public class ProximitySensor
implements ConferenceLock,
SensorEventListener {
    private static final float NEAR = 0.0f;
    private static final float FAR = 5.0f;
    private static final String TAG = "Sensor";
    private PowerManager.WakeLock mScreenOn;
    private PowerManager.WakeLock mScreenOff;
    private Sensor mProximity;
    private SensorManager mSensorManager;
    private Context mContext;
    private boolean acquired = false;
    private float last = 5.0f;

    private ProximitySensor() {
    }

    public ProximitySensor(@NonNull Context context) {
        this();
        PowerManager manager;
        this.mContext = context;
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        if (null != this.mSensorManager) {
            this.mProximity = this.mSensorManager.getDefaultSensor(8);
        }
        if (null != (manager = (PowerManager)this.mContext.getSystemService("power"))) {
            String t = "Sensor:";
            this.mScreenOn = manager.newWakeLock(0x1000000A, t);
            this.mScreenOff = manager.newWakeLock(32, t);
        }
    }

    @Override
    public void acquire() {
        Log.d((String)TAG, (String)("acquire: " + this.acquired + " "));
        if (!this.acquired && null != this.mSensorManager) {
            this.acquired = this.mSensorManager.registerListener((SensorEventListener)this, this.mProximity, 3);
        }
        Log.d((String)TAG, (String)("acquire: now " + this.acquired + " "));
        this.updateLock();
    }

    @Override
    public void release() {
        if (this.acquired) {
            this.mSensorManager.unregisterListener((SensorEventListener)this);
            this.acquired = false;
        }
        this.last = 5.0f;
        this.releaseLocks();
    }

    @Override
    public boolean isProximity() {
        return true;
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.values.length >= 0) {
            this.last = event.values[0];
        }
        this.updateLock();
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void updateLock() {
        try {
            if (this.last >= 5.0f) {
                if (this.mScreenOff.isHeld()) {
                    this.mScreenOff.release();
                }
                this.mScreenOn.acquire();
            } else {
                if (this.mScreenOn.isHeld()) {
                    this.mScreenOn.release();
                }
                this.mScreenOff.acquire();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void releaseLocks() {
        try {
            if (this.mScreenOn.isHeld()) {
                this.mScreenOn.release();
            }
            if (this.mScreenOff.isHeld()) {
                this.mScreenOff.release();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

