/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.authent.models.DeviceType;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.HashMap;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="DeviceType")
public class JoinParameters
extends Event {
    @JsonProperty(value="device_type")
    private DeviceType deviceType;
    @JsonProperty(value="sdp_version")
    private String sdpVersion;
    @JsonProperty(value="participantType")
    private String participantType;
    @JsonProperty(value="metadata")
    private HashMap<String, Object> metadata = new HashMap();
    @JsonProperty(value="sync")
    private boolean sync = true;

    public JoinParameters() {
    }

    public JoinParameters(DeviceType deviceType, boolean listenerMode) {
        this();
        this.deviceType = deviceType;
        this.sdpVersion = MediaSDK.getSDPVersion();
        if (null == this.sdpVersion) {
            this.sdpVersion = "SDP_V2";
        }
        this.participantType = listenerMode ? "LISTENER" : "USER";
    }

    public String getParticipantType() {
        return this.participantType;
    }

    public void setParticipantType(String participantType) {
        this.participantType = participantType;
    }

    public String getSdpVersion() {
        return this.sdpVersion;
    }

    public void setSdpVersion(String sdpVersion) {
        this.sdpVersion = sdpVersion;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    @Override
    @NoDocumentation
    public String getType() {
        return "DeviceType";
    }

    public boolean isSync() {
        return this.sync;
    }
}

