/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.authent.KeySecretTokenResponseProvider;
import com.voxeet.authent.OAuthTokenResponseProvider;
import com.voxeet.authent.endpoints.IVoxeetRService;
import com.voxeet.authent.exceptions.AuthentExceptionListener;
import com.voxeet.authent.models.DeviceType;
import com.voxeet.authent.models.UserInfoBody;
import com.voxeet.authent.models.UserTokenResponse;
import com.voxeet.authent.token.RefreshTokenCallback;
import com.voxeet.authent.token.TokenResponseProvider;
import com.voxeet.log.factory.LogFactory;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.preferences.VoxeetPreferences;
import com.voxeet.sdk.services.authenticate.VoxeetCookieJar;
import com.voxeet.sdk.services.notification.INotificationTokenProvider;
import com.voxeet.sdk.services.notification.NotificationTokenHolderFactory;
import com.voxeet.sdk.utils.converter.JacksonConverterFactory;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class VoxeetHttp {
    private static final String TAG = VoxeetHttp.class.getSimpleName();
    private final VoxeetSdk sdk;
    private Context appContext;
    private String serverUrl;
    private String serverPort;
    private Retrofit retrofit;
    private OkHttpClient client;
    private TokenResponseProvider tokenResponseProvider;
    private VoxeetServiceListener listener;
    private boolean debug = false;
    private OkHttpClient clientIdentify;
    private OkHttpClient clientSubIdentify;
    private Retrofit retrofitIdentify;
    private Retrofit retrofitSubIdentify;
    private VoxeetCookieJar cookieJar;

    private VoxeetHttp(Context appContext, VoxeetSdk sdk, String serverUrl, String serverPort, String appId, String password, VoxeetServiceListener listener, String tokenAccess, RefreshTokenCallback tokenRefresh, boolean debug) {
        this.sdk = sdk;
        this.serverUrl = serverUrl;
        this.serverPort = serverPort;
        this.appContext = appContext;
        this.debug = debug;
        this.listener = listener;
        if (null != appId && null != password) {
            Log.d((String)TAG, (String)"VoxeetHttp: initializing using appId/password");
            this.tokenResponseProvider = new KeySecretTokenResponseProvider(appId, password, sdk.getVoxeetEnvironmentHolder().getVersionName(), new AuthentExceptionListener(){

                public void onException(@NonNull Throwable throwable) {
                    ExceptionManager.sendException(throwable);
                }
            });
        } else if (null != tokenRefresh) {
            Log.d((String)TAG, (String)"VoxeetHttp: initializing using access/refresh");
            this.tokenResponseProvider = new OAuthTokenResponseProvider(tokenAccess, tokenRefresh, sdk.getVoxeetEnvironmentHolder().getVersionName(), new AuthentExceptionListener(){

                public void onException(@NonNull Throwable throwable) {
                    ExceptionManager.sendException(throwable);
                }
            });
        }
        this.initClient();
        this.initRetrofit();
        this.initService();
    }

    private void initClient() {
        this.cookieJar = new VoxeetCookieJar(this.getBuiltServerUrl());
        OkHttpClient.Builder builderIdentify = new OkHttpClient.Builder().cookieJar((CookieJar)this.cookieJar).addNetworkInterceptor(new Interceptor(){

            public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
                Log.d((String)TAG, (String)"intercept: builderIdentify");
                return VoxeetHttp.this.tokenResponseProvider.executeIdentify(chain, "builderIdentify");
            }
        });
        OkHttpClient.Builder builderSubIdentify = new OkHttpClient.Builder().cookieJar((CookieJar)this.cookieJar).addNetworkInterceptor(new Interceptor(){

            public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
                Log.d((String)TAG, (String)"intercept: builderSubIdentify");
                return VoxeetHttp.this.tokenResponseProvider.executeIdentify(chain, "builderSubIdentify");
            }
        });
        OkHttpClient.Builder builder = new OkHttpClient.Builder().cookieJar((CookieJar)this.cookieJar).addNetworkInterceptor(new Interceptor(){

            public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
                Log.d((String)TAG, (String)"intercept: builder");
                return VoxeetHttp.this.tokenResponseProvider.execute(chain);
            }
        });
        this.tokenResponseProvider.configureOkHttpClientBuilder(builder, true);
        this.tokenResponseProvider.configureOkHttpClientBuilder(builderIdentify, true);
        this.tokenResponseProvider.configureOkHttpClientBuilder(builderSubIdentify, false);
        if (this.debug) {
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                @SuppressLint(value={"BadHostnameVerifier"})
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            builder = builder.hostnameVerifier(hostnameVerifier);
            builderIdentify = builderIdentify.hostnameVerifier(hostnameVerifier);
            builderSubIdentify = builderSubIdentify.hostnameVerifier(hostnameVerifier);
        }
        this.client = builder.build();
        this.clientIdentify = builderIdentify.build();
        this.clientSubIdentify = builderSubIdentify.build();
    }

    private void initRetrofit() {
        this.retrofit = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.client).build();
        this.retrofitIdentify = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.clientIdentify).build();
        this.retrofitSubIdentify = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.clientSubIdentify).build();
    }

    private void initService() {
        this.tokenResponseProvider.initService((IVoxeetRService)this.retrofitIdentify.create(IVoxeetRService.class), (IVoxeetRService)this.retrofitSubIdentify.create(IVoxeetRService.class));
    }

    public Promise<Boolean> identifyChain(final UserInfo userInfo) {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> final_solver) {
                String token;
                LogFactory.instance.connect();
                UserInfoBody userInfoBody = new UserInfoBody(userInfo.getName(), userInfo.getExternalId(), userInfo.getAvatarUrl());
                VoxeetHttp.this.tokenResponseProvider.setUserInfo(userInfoBody);
                VoxeetPreferences.setExternalUserInfo(userInfo);
                userInfoBody.setDeviceIdentifier(VoxeetPreferences.deviceIdentifier());
                userInfoBody.setDeviceType(DeviceType.ANDROID);
                INotificationTokenProvider provider = NotificationTokenHolderFactory.provider;
                if (null != provider && provider.isTokenUploadAllowed() && (token = provider.getToken()) != null) {
                    Log.d((String)TAG, (String)"onCall: token obtained");
                    userInfoBody.setDevicePushToken(token);
                }
                VoxeetHttp.this.tokenResponseProvider.retrieve().then(new PromiseExec<UserTokenResponse, Object>(){

                    @Override
                    public void onCall(@Nullable UserTokenResponse result, @NonNull Solver<Object> solver) {
                        if (null != result) {
                            Log.d((String)TAG, (String)("Successful login with id " + result.getId()));
                            VoxeetPreferences.setId(result.getId());
                            VoxeetPreferences.saveLoginCookie(result.getUserToken());
                            VoxeetHttp.this.listener.onIdentifySuccess(VoxeetHttp.this);
                            List<Cookie> cookies = VoxeetHttp.this.cookieJar.getCookies(VoxeetHttp.this.getBuiltServerUrl());
                            if (cookies != null && cookies.size() > 0) {
                                VoxeetPreferences.saveLoginCookie(cookies.get(0).toString());
                            }
                            final_solver.resolve(true);
                        } else {
                            final_solver.resolve(false);
                        }
                    }
                }).error(new ErrorPromise(){

                    @Override
                    public void onError(@NonNull Throwable error) {
                        error.printStackTrace();
                        if (error instanceof UnknownHostException) {
                            VoxeetHttp.this.listener.onNetworkError((UnknownHostException)error);
                        } else {
                            VoxeetHttp.this.listener.onIdentifyError(error.getMessage());
                        }
                        final_solver.reject(error);
                    }
                });
            }
        });
    }

    public Promise<Boolean> logout(final @NonNull String id) {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                VoxeetHttp.this.tokenResponseProvider.logout().then(new PromiseExec<Boolean, Object>(){

                    @Override
                    public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                        VoxeetHttp.this.cleanUserSession(id);
                        solver.resolve(result);
                    }
                }).error(new ErrorPromise(){

                    @Override
                    public void onError(@NonNull Throwable error) {
                        solver.reject(error);
                    }
                });
            }
        });
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    Retrofit getRetrofit() {
        return this.retrofit;
    }

    @Nullable
    String getToken() {
        return this.tokenResponseProvider.getToken();
    }

    @Nullable
    public String getJwtToken() {
        return this.tokenResponseProvider.getJwtToken();
    }

    public void resetVoxeetHttp() {
        this.tokenResponseProvider.resetVoxeetHttp();
    }

    public void cleanUserSession(@NonNull String id) {
        this.tokenResponseProvider.cleanUserSession(id);
    }

    String getBuiltServerUrl() {
        String port = this.serverPort;
        if (!port.startsWith(":")) {
            port = ":" + port;
        }
        return this.serverUrl + port;
    }

    public static final class Builder {
        private Context _application;
        private VoxeetSdk _sdk;
        private String _server_url;
        private String _server_port;
        private String _app_id;
        private String _password;
        private String _tokenAccess;
        private RefreshTokenCallback _tokenRefresh;
        private VoxeetServiceListener _listener;
        private boolean _debug;

        Builder() {
        }

        public Builder setApplication(Context application) {
            this._application = application;
            return this;
        }

        public Builder setVoxeetSDK(VoxeetSdk sdk) {
            this._sdk = sdk;
            return this;
        }

        Builder setServerUrl(String serverUrl) {
            this._server_url = serverUrl;
            return this;
        }

        public Builder setServerPort(String serverPort) {
            this._server_port = serverPort;
            return this;
        }

        public Builder setAppId(String appId) {
            this._app_id = appId;
            return this;
        }

        public Builder setPassword(String password) {
            this._password = password;
            return this;
        }

        public Builder setVoxeetServiceListener(VoxeetServiceListener listener) {
            this._listener = listener;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this._debug = debug;
            return this;
        }

        public Builder setTokenAccess(String tokenAccess) {
            this._tokenAccess = tokenAccess;
            return this;
        }

        public Builder setTokenRefresh(RefreshTokenCallback tokenRefresh) {
            this._tokenRefresh = tokenRefresh;
            return this;
        }

        public VoxeetHttp build() {
            return new VoxeetHttp(this._application, this._sdk, this._server_url, this._server_port, this._app_id, this._password, this._listener, this._tokenAccess, this._tokenRefresh, this._debug);
        }
    }

    public static interface VoxeetServiceListener {
        public void onIdentifySuccess(VoxeetHttp var1);

        public void onIdentifyError(String var1);

        public void onNetworkError(UnknownHostException var1);
    }
}

