/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.sdk.VoxeetHttp;
import com.voxeet.sdk.VoxeetJsonError;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.services.holder.ServiceProviderHolder;
import java.io.IOException;
import org.greenrobot.eventbus.EventBus;

public abstract class AbstractVoxeetService<T> {
    private static final String TAG = AbstractVoxeetService.class.getSimpleName();
    @NonNull
    private ServiceProviderHolder<T> holder = ServiceProviderHolder.DEFAULT;
    protected static final Handler handler = new Handler(Looper.getMainLooper());
    protected Context context;

    private AbstractVoxeetService() {
    }

    protected AbstractVoxeetService(@NonNull VoxeetSdk instance, @Nullable Class<T> service_klass) {
        this(instance, new ServiceProviderHolder.Builder().setClient(instance.getClient()).setRetrofit(instance.getRetrofit()).setService(service_klass).build());
    }

    protected AbstractVoxeetService(@NonNull VoxeetSdk instance, @NonNull ServiceProviderHolder<T> holder) {
        this();
        this.context = instance.getApplicationContext();
        this.holder = holder;
    }

    protected final T getService() {
        return this.holder.getService();
    }

    public String handleError(@Nullable Throwable e) {
        if (null == e) {
            return "invalid error";
        }
        Log.d((String)TAG, (String)("handleError: " + e.getClass().getSimpleName()));
        return e.getMessage();
    }

    protected static VoxeetJsonError getErrorBody(String message) {
        ObjectMapper om = new ObjectMapper();
        VoxeetJsonError command = null;
        try {
            command = (VoxeetJsonError)om.readValue(message, VoxeetJsonError.class);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"failed to get error body", (Throwable)e);
        }
        return command;
    }

    public void resetService() {
    }

    @Nullable
    protected final String getURLRoot(@NonNull VoxeetSdk template) {
        return template.getVoxeetHttp().getBuiltServerUrl();
    }

    @Nullable
    protected final String getInternalToken(@NonNull VoxeetSdk template) {
        return template.getVoxeetHttp().getToken();
    }

    @Nullable
    protected final String getInternalJwtToken(@NonNull VoxeetSdk template) {
        return template.getVoxeetHttp().getJwtToken();
    }

    protected final VoxeetHttp getVoxeetHttp(VoxeetSdk template) {
        return template.getVoxeetHttp();
    }

    protected EventBus getEventBus() {
        return this.holder.getEventBus();
    }

    protected void registerEventBus() {
        EventBus eventBus = this.holder.getEventBus();
        try {
            if (!eventBus.isRegistered((Object)this)) {
                eventBus.register((Object)this);
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"registerEventBus: logging for debug purposes :");
            e.printStackTrace();
        }
    }

    protected void unRegisterEventBus() {
        EventBus eventBus = this.holder.getEventBus();
        try {
            if (eventBus.isRegistered((Object)this)) {
                eventBus.unregister((Object)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void postOnMainThread(@NonNull Runnable runnable) {
        handler.post(runnable);
    }

    protected boolean isInProperServiceState(AbstractVoxeetService ... services) {
        if (null == services || services.length == 0) {
            return false;
        }
        for (AbstractVoxeetService service : services) {
            if (null != service) continue;
            return false;
        }
        return true;
    }

    protected boolean throwInvalidServices() {
        throw new IllegalStateException("Invalid service state... stopping...");
    }
}

