/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.push.center.NotificationCenterFactory;
import com.voxeet.push.center.invitation.IIncomingInvitationListener;
import com.voxeet.push.center.invitation.InvitationBundle;
import com.voxeet.push.center.management.EnforcedNotificationMode;
import com.voxeet.push.center.management.NotificationMode;
import com.voxeet.push.center.management.VersionFilter;
import com.voxeet.push.utils.Annotate;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.core.services.notification.INotificationTokenProvider;
import com.voxeet.sdk.core.services.notification.NotificationTokenHolderFactory;

@Annotate
public class NotificationService
extends AbstractVoxeetService {
    public NotificationService(@NonNull VoxeetSdk instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
    }

    @Nullable
    public INotificationTokenProvider getNotificationTokenProvider() {
        return NotificationTokenHolderFactory.provider;
    }

    @NonNull
    public NotificationService setNotificationTokenProvider(@Nullable INotificationTokenProvider provider) {
        NotificationTokenHolderFactory.provider = provider;
        return this;
    }

    @NonNull
    public NotificationService setEnforcedNotificationMode(@NonNull EnforcedNotificationMode enforcedNotificationMode) {
        NotificationCenterFactory.instance.setEnforcedNotificationMode(enforcedNotificationMode);
        return this;
    }

    @NonNull
    public NotificationService register(@NonNull NotificationMode notificationMode, @Nullable IIncomingInvitationListener invitationProvider) {
        NotificationCenterFactory.instance.register(notificationMode, invitationProvider);
        return this;
    }

    @NonNull
    public NotificationService register(@NonNull NotificationMode notificationMode, @NonNull VersionFilter filter) {
        NotificationCenterFactory.instance.register(notificationMode, filter);
        return this;
    }

    public void onInvitationReceived(@NonNull Context context, @NonNull InvitationBundle invitationBundle) {
        NotificationCenterFactory.instance.onInvitationReceived(context, invitationBundle.asMap(), Build.MANUFACTURER, Build.VERSION.SDK_INT);
    }

    @NonNull
    public String onInvitationCanceledReceived(@NonNull Context context, @NonNull InvitationBundle invitationBundle) {
        return NotificationCenterFactory.instance.onInvitationCanceledReceived(context, invitationBundle.asMap(), Build.MANUFACTURER, Build.VERSION.SDK_INT);
    }
}

