package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.MetaData;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

@FromWebsocket
@Annotate
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.PARTICIPANT_ADDED)
public class ParticipantAdded extends Event {

    @JsonProperty("user_id")
    public String userId;

    @JsonProperty("conference_id")
    public String conferenceId;

    @JsonProperty("conference_alias")
    public String conferenceAlias;

    public String status;

    public String name;

    public String externalId;

    public String avatarUrl;

    public MetaData metadata;

    @Override
    public String getType() {
        return EventNames.PARTICIPANT_ADDED;
    }
}
