package com.voxeet.sdk.core.services.presentation;

import com.voxeet.sdk.utils.Annotate;

/**
 * Enum to represents the all possible lifecycle for a Presentation
 *
 * The default behaviour is started. And then, the following diagram :
 *
 * - started (play as well)
 * - started -> play
 * - started -> pause
 * - started -> seek
 * - started -> stop
 *
 * - play -> pause
 * - play -> seek
 * - play -> stop
 *
 * - pause -> play
 * - pause -> seek
 * - pause -> stop
 *
 * - seek -> pause
 * - seek -> play
 * - seek -> seek
 * - seek -> stop
 *
 * - stop -> terminal
 */
@Annotate
public enum PresentationState {
    STARTED,
    PLAY,
    PAUSED,
    SEEK,
    STOP, CONVERTED;
}
