package com.voxeet.sdk.utils;

import android.support.annotation.NonNull;
import android.util.Log;

import com.voxeet.android.media.MediaStream;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.json.ParticipantUpdated;
import com.voxeet.sdk.models.User;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public abstract class EventCallback {
    private static final String TAG = EventCallback.class.getSimpleName();

    public void register(VoxeetSdk template) {
        EventBus eventBus = template.getEventBus();

        try {
            if (!eventBus.isRegistered(this)) {
                eventBus.register(this);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregister(VoxeetSdk template) {
        EventBus eventBus = template.getEventBus();

        try {
            if (eventBus.isRegistered(this)) {
                eventBus.unregister(this);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPush event) {
        onConferenceDestroyed(event.conferenceId);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEvent(ParticipantUpdated event) {
        Log.d(TAG, "onEvent: ParticipantUpdated " + event + " " + event.userId + " " + event.status + " " + event.conferenceId);
        onParticipantUpdated(event.conferenceId, event.userId, event.status);
    }

    protected abstract void onConferenceDestroyed(String conferenceId);

    protected abstract void onParticipantUpdated(String confId, String userId, String status);

    protected abstract void onParticipantLeft(@NonNull User user);

    protected abstract void onUserJoined(@NonNull User user, MediaStream mediaStream);

    protected abstract void onUserUpdated(@NonNull User user, MediaStream mediaStream);

    protected abstract void onScreenAdded(String peer, MediaStream mediaStream);

    protected abstract void onScreenRemoved(String peer);
}
