package com.voxeet.sdk.core.services;

import com.voxeet.sdk.core.network.endpoints.ISdkConferenceRService;
import com.voxeet.sdk.events.restapi.ConferenceStatusResult;
import com.voxeet.sdk.events.restapi.ReplayConferenceResult;
import com.voxeet.sdk.events.restapi.ResumeConference;
import com.voxeet.sdk.json.BroadcastEvent;
import com.voxeet.sdk.json.CreateConferenceParams;
import com.voxeet.sdk.json.JoinParameters;
import com.voxeet.sdk.json.SdkConferenceInvitation;
import com.voxeet.sdk.json.SdkConferenceReplayBody;
import com.voxeet.sdk.json.StartScreenSharingResponse;
import com.voxeet.sdk.json.StartVideoResponse;
import com.voxeet.sdk.json.StopScreenSharingResponse;
import com.voxeet.sdk.json.StopVideoResponse;
import com.voxeet.sdk.media.peer.SdpDescription;
import com.voxeet.sdk.models.v1.CandidatesPush;
import com.voxeet.sdk.models.v1.CreateConferenceResult;
import com.voxeet.sdk.models.v1.HistoryConference;
import com.voxeet.sdk.models.v1.SubscribeConference;

import java.util.List;

import okhttp3.ResponseBody;
import retrofit2.Call;

public class ConferenceSdkObservableProvider {

    private ISdkConferenceRService mService;

    protected ISdkConferenceRService getService() {
        return mService;
    }

    public void setRetrofitInstantiatedProvider(ISdkConferenceRService service) {
        mService = service;
    }

    public Call<ResponseBody> leaveConference(String conferenceId) {
        return getService().leaveConference(conferenceId);
    }

    public Call<ResponseBody> getDeclineObservable(String conferenceId) {
        return getService().decline(conferenceId);
    }

    public Call<StartVideoResponse> getStartVideoObservable(String conferenceId, String id) {
        return getService().startVideo(conferenceId, id);
    }

    public Call<StopVideoResponse> getStopVideoObservable(String conferenceId, String id) {
        return getService().stopVideo(conferenceId, id);
    }

    public Call<StartScreenSharingResponse> getStartScreenShareObservable(String conferenceId, String id) {
        return getService().startScreenShare(conferenceId);
    }

    public Call<StopScreenSharingResponse> getStopScreenShareObservable(String conferenceId, String id) {
        return getService().stopScreenShare(conferenceId);
    }

    public Call<CreateConferenceResult> getCreateConferenceObservable(CreateConferenceParams params) {
        return getService().createConference(params); //with default stats to true
    }

    public Call<CreateConferenceResult> getCreateDemoObservable() {
        return getService().createDemo();
    }

    public Call<ResponseBody> getInviteObservable(String conferenceId, SdkConferenceInvitation sdkConferenceInvitation) {
        return getService().invite(conferenceId, sdkConferenceInvitation);
    }

    public Call<ReplayConferenceResult> getReplayObservable(String conferenceId, SdkConferenceReplayBody sdkConferenceReplayBody) {
        return getService().replay(conferenceId, sdkConferenceReplayBody);
    }

    public Call<ResponseBody> getStartRecordingObservable(String conferenceId) {
        return getService().startRecording(conferenceId);
    }

    public Call<ResponseBody> getStopRecordingObservable(String conferenceId) {
        return getService().stopRecording(conferenceId);
    }

    public Call<ConferenceStatusResult> getConferenceStatusObservable(String conferenceId) {
        return getService().conferenceStatus(conferenceId);
    }

    public Call<List<HistoryConference>> getConferenceHistoryObservable(String conferenceId) {
        return getService().conferenceHistory(conferenceId);
    }

    public Call<SubscribeConference> getSubscribeObservable(String conferenceId) {
        return getService().subscribe(conferenceId);
    }

    public Call<ResponseBody> getUnSubscribeObservable(String conferenceId) {
        return getService().unSubscribe(conferenceId);
    }

    public Call<ResponseBody> getSubscribeForCallObservable(String conferenceId) {
        return getService().subscribeForCall(conferenceId);
    }

    public Call<ResponseBody> getUnSubscribeFromCallObservable(String conferenceId) {
        return getService().unsubscribeFromCall(conferenceId);
    }

    public Call<ResumeConference> joinConference(String conferenceId, JoinParameters deviceEvent) {
        return getService().joinConference(conferenceId, deviceEvent);
    }

    public Call<ResponseBody> answerConference(String conferenceId, String peer, SdpDescription description) {
        return getService().answerConference(conferenceId, peer, description);
    }

    public Call<ResponseBody> broadcastMessage(String conferenceId, BroadcastEvent broadcastEvent) {
        return getService().broadcastMessage(conferenceId, broadcastEvent);
    }

    public Call<ResponseBody> candidates(String conferenceId, String peerId, CandidatesPush candidates) {
        return getService().candidates(conferenceId, peerId, candidates);
    }

    public Call<ResponseBody> renegociate(String conferenceId) {
        return getService().renegociate(conferenceId);
    }

    public Call<ResponseBody> iceRestart(String conferenceId) {
        return getService().iceRestart(conferenceId);
    }
}
