package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.OfferCandidate;
import com.voxeet.sdk.models.v1.OfferDescription;
import com.voxeet.sdk.utils.FromRestAPI;
import com.voxeet.sdk.utils.InternalEvent;

import java.util.List;

/**
 * Event fired when a screenshare has been stopped
 */
@InternalEvent
@FromRestAPI
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.STOP_SCREENSHARE)
public class StopScreenSharingResponse extends Event {

    @JsonProperty("candidates")
    public List<OfferCandidate> candidates;

    @JsonProperty("description")
    public OfferDescription description;

    @JsonProperty("user_id")
    public String userId;

    @Override
    public String getType() {
        return EventNames.STOP_VIDEO;
    }
}
