package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.File;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.ToDelete;

import java.util.List;

@Annotate
@ToDelete
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.FILE_ADDED)
public class FileAddedEvent extends Event {

    public List<File> files;

    @Override
    public String getType() {
        return EventNames.FILE_ADDED;
    }
}
