package com.voxeet.sdk.events.sdk;

import android.support.annotation.NonNull;

import com.voxeet.sdk.core.services.authenticate.WebSocketState;
import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

@Annotate
@FromSDK
public class SocketStateChangeEvent {

    /**
     * The new state of the socket
     */
    @NonNull
    public WebSocketState state;

    @NoDocumentation
    public SocketStateChangeEvent(@NonNull WebSocketState state) {
        this.state = state;
    }
}
