package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.restapi.ConferenceStatusResult;
import com.voxeet.sdk.events.sdk.ConferenceUsersInvitedResult;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.utils.ConferenceUtils;
import com.voxeet.sdk.utils.HttpHelper;

import org.greenrobot.eventbus.EventBus;

import java.util.List;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import retrofit2.Call;
import retrofit2.Response;

public class GetConferenceStatus extends AbstractPromiseable<ConferenceUsersInvitedResult> {

    public GetConferenceStatus(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<ConferenceUsersInvitedResult> createPromise() {
        return new Promise<>(new PromiseSolver<ConferenceUsersInvitedResult>() {
            @Override
            public void onCall(@NonNull final Solver<ConferenceUsersInvitedResult> solver) {
                final Call<ConferenceStatusResult> user = getProvider().getConferenceStatusObservable(getInformation().getConference().getId());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ConferenceStatusResult>() {
                    @Override
                    public void onSuccess(@NonNull ConferenceStatusResult object, @NonNull Response<ConferenceStatusResult> response) {
                        List<ConferenceUser> users = ConferenceUtils.getConferenceUserInState(object.getConferenceUsers(), ConferenceUserStatus.CONNECTING);

                        log("Successfully retrieved connecting users");

                        ConferenceUsersInvitedResult event = new ConferenceUsersInvitedResult(users);
                        solver.resolve(event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ConferenceStatusResult> response) {
                        HttpException.dumpErrorResponse(response);

                        log("Error while retrieving connecting users");

                        solver.reject(e);
                    }
                });
            }
        });
    }
}
