package com.voxeet.sdk.core.services.conference.information;

import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Represents the various conference state
 * - default (instantiated)
 * - creating
 * - created
 * - joining
 * - joined
 * - a first participant joined (different than the currently logged in user)
 * - no more participants are in the conference
 * - leaving
 * - left
 */
@Annotate
public enum ConferenceState {
    DEFAULT(true),
    CREATING(true),
    CREATED(true),
    CREATED_ERROR(true),
    JOINING(true),
    JOINED(true),
    JOINED_ERROR(true),
    FIRST_PARTICIPANT(true),
    NO_MORE_PARTICIPANT(true),
    LEAVING(false),
    LEFT(false),
    LEFT_ERROR(false);

    private final boolean mValid;

    @NoDocumentation
    ConferenceState(boolean valid) {
        mValid = valid;
    }

    /**
     * Check if the current state is a valid one - corresponds to a conference which is attended
     *
     * @return a boolean indicating if a conference can be done in parallel of this state
     */
    public boolean isValid() {
        return mValid;
    }
}
