package com.voxeet.sdk.core.services.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v2.ChatMessage;
import com.voxeet.sdk.utils.Annotate;

/**
 * Hold chat information
 */
@Annotate
public class ChatMessageEvent {
    /**
     * Instance of the user who emitted the message
     */
    @Nullable
    public User user;

    /**
     * Instance of the message sent by the user
     */
    @NonNull
    public ChatMessage message;

    /**
     * Creates a new message using an user and a message
     *
     * @param user instance of the user or null if sent by system
     * @param message message to be sent
     */
    public ChatMessageEvent(@Nullable User user, @NonNull ChatMessage message) {
        this.user = user;
        this.message = message;
    }
}
