package com.voxeet.sdk.core.network.websocket;

import android.support.annotation.NonNull;
import android.util.Log;

import com.voxeet.sdk.core.VoxeetHttp;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.VoxeetDispatcher;
import com.voxeet.sdk.core.services.authenticate.WebSocketState;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;

import okhttp3.WebSocket;

public class VoxeetWebSocket {
    //TODO if socket state for non eventbus is required, add connect with ConnectListener

    private static final String TAG = VoxeetWebSocket.class.getSimpleName();
    private AbstractVoxeetEnvironmentHolder environment_holder;

    /**
     * The constant SOCKET_ERROR.
     */
    public static final String SOCKET_ERROR = "SOCKET_ERROR";

    /**
     * The constant SOCKET_MESSAGE.
     */
    public static final String SOCKET_MESSAGE = "SOCKET_TEXT";

    /**
     * The constant SOCKET_CONNECTED.
     */
    public static final String SOCKET_CONNECTED = "SOCKET_CONNECTED";

    /**
     * The constant SOCKET_DISCONNECTED.
     */
    public static final String SOCKET_DISCONNECTED = "SOCKET_DISCONNECTED";

    private String socketUrl;

    private WebSocketProxy mWebSocketProxy;

    //private ConnectListener mConnectListener;

    private SocketListener listener = new SocketListener() {

        @Override
        public void onConnect(WebSocket webSocket) {
            VoxeetDispatcher.dispatch(SOCKET_CONNECTED, "Connected");
        }

        @Override
        public void onTextMessage(String message) {
            VoxeetDispatcher.dispatch(SOCKET_MESSAGE, message);
        }

        @Override
        public void onError(HttpException exception) {
            exception.printStackTrace();
            if (null != exception.getResponse()) {
                try {
                    Log.d(TAG, "onError: http exception for socket (message) " + exception.getResponse().message());
                    Log.d(TAG, "onError: http exception for socket (body) " + exception.getResponse().body().toString());
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            VoxeetDispatcher.dispatch(SOCKET_ERROR, "Error " + exception.getMessage());
        }

        @Override
        public void onClose() {
            //TODO close event ?
        }

        @Override
        public void onStateChanged(WebSocketState newState) {
            Log.d(TAG, "onStateChanged: newState:=" + newState);
            VoxeetDispatcher.dispatch(newState);
        }

        @Override
        public void onDisconnected() {
            Log.d(TAG, "Websocket disconnect by server");

            VoxeetDispatcher.dispatch(SOCKET_DISCONNECTED, "on Disconnected by server: ");
        }
    };

    /**
     * Instantiates a new Voxeet web socket.
     *
     * @param sdk       the instance of the sdk to plug into
     * @param socketUrl the url to connect to
     */
    public VoxeetWebSocket(VoxeetSdk sdk,
                           @NonNull String socketUrl) {
        environment_holder = sdk.getVoxeetEnvironmentHolder();
        this.socketUrl = socketUrl;
    }

    /**
     * Connect the socket.
     *
     * @param provider alternative socket listener
     */
    public void connect(@NonNull VoxeetHttp provider) {
        if (null != mWebSocketProxy) {
            mWebSocketProxy.removeListeners();
            mWebSocketProxy.cancel();
            mWebSocketProxy.disconnect();
        }
        createProxy();

        mWebSocketProxy.connect(provider, null); //, mConnectListener);
    }

    private void clear() {
        VoxeetDispatcher.dispatch(WebSocketState.CLOSED);
        if (null != mWebSocketProxy) {
            mWebSocketProxy.cancel();
            mWebSocketProxy.disconnect();
            mWebSocketProxy.removeListener(listener);
            mWebSocketProxy.removeListeners();
        }
        mWebSocketProxy = null;
    }

    private void createProxy() {
        mWebSocketProxy = new WebSocketProxy(socketUrl, environment_holder.getVersionName());
        mWebSocketProxy.addListener(listener);
    }

    /**
     * Close the web socket.
     */
    public void close(boolean set_disconnect) {
        //TODO manage set_disconnect ?
        clear();
    }

    public boolean isOpen() {
        return mWebSocketProxy != null && mWebSocketProxy.isOpen();
    }

    /**
     * Returns the socket status.
     *
     * @return the boolean
     */
    public boolean isInit() {
        return mWebSocketProxy != null && mWebSocketProxy.isOpen();//sendPing();
    }

}
