package com.voxeet.sdk.core.network.endpoints;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface ISdkVideoPresentationRService {

    @POST("/v1/conferences/{conferenceId}/videopresentation/start")
    Call<ResponseBody> startVideoPresentation(@Path("conferenceId") String conferenceId,
                                              @Body VideoPresentationUrl url);


    @POST("/v1/conferences/{conferenceId}/videopresentation/stop")
    Call<ResponseBody> stopVideoPresentation(@Path("conferenceId") String conferenceId);


    @POST("/v1/conferences/{conferenceId}/filepresentation/play")
    Call<ResponseBody> playVideoPresentation(@Path("conferenceId") String conferenceId);

    @POST("/v1/conferences/{conferenceId}/filepresentation/pause")
    Call<ResponseBody> pauseVideoPresentation(@Path("conferenceId") String conferenceId,
                                              @Body VideoPresentationSeek body);

    @POST("/v1/conferences/{conferenceId}/filepresentation/seek")
    Call<ResponseBody> seekVideoPresentation(@Path("conferenceId") String conferenceId,
                                             @Body VideoPresentationSeek body);


    public class VideoPresentationUrl {
        public String url;

        private VideoPresentationUrl() {

        }

        public VideoPresentationUrl(String url) {
            this();

            this.url = url;
        }
    }

    public class VideoPresentationSeek {
        public long timestamp;

        private VideoPresentationSeek() {

        }

        public VideoPresentationSeek(long timestamp) {
            this();

            this.timestamp = timestamp;
        }
    }
}
