/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.preferences;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.preferences.IPreferencesProvider;
import java.util.HashMap;

public class SharedPreferencesCacheWrapper
implements IPreferencesProvider {
    @NonNull
    private HashMap<String, String> mStrings = new HashMap();
    @NonNull
    private HashMap<String, Boolean> mBooleans = new HashMap();
    @NonNull
    private HashMap<String, Long> mLongs = new HashMap();
    @NonNull
    private HashMap<String, Integer> mInts = new HashMap();
    private SharedPreferences mPreferences;

    private SharedPreferencesCacheWrapper() {
    }

    public SharedPreferencesCacheWrapper(SharedPreferences preferences) {
        this();
        this.mPreferences = preferences;
    }

    @Override
    @NonNull
    public IPreferencesProvider.Editor edit() {
        return new EditorWrapper(this);
    }

    @Override
    @Nullable
    public String getString(@NonNull String key, @Nullable String def) {
        if (this.mStrings.containsKey(key)) {
            return this.mStrings.get(key);
        }
        String result = this.mPreferences.getString(key, def);
        return result;
    }

    @Override
    public boolean getBoolean(@NonNull String key, boolean def) {
        if (this.mBooleans.containsKey(key)) {
            return this.mBooleans.get(key);
        }
        return this.mPreferences.getBoolean(key, def);
    }

    @Override
    public int getInt(@NonNull String key, int def) {
        if (this.mInts.containsKey(key)) {
            return this.mInts.get(key);
        }
        return this.mPreferences.getInt(key, def);
    }

    @Override
    public long getLong(@NonNull String key, long def) {
        if (this.mLongs.containsKey(key)) {
            return this.mLongs.get(key);
        }
        return this.mPreferences.getLong(key, def);
    }

    @Override
    public boolean contains(@NonNull String key) {
        if (this.mStrings.containsKey(key)) {
            return true;
        }
        if (this.mBooleans.containsKey(key)) {
            return true;
        }
        if (this.mLongs.containsKey(key)) {
            return true;
        }
        return this.mPreferences.contains(key);
    }

    private class EditorWrapper
    implements IPreferencesProvider.Editor {
        private SharedPreferencesCacheWrapper _wrapper;
        private SharedPreferences.Editor _editor_editor;

        public EditorWrapper(SharedPreferencesCacheWrapper wrapper) {
            this._wrapper = wrapper;
            this._editor_editor = wrapper.mPreferences.edit();
        }

        @Override
        public IPreferencesProvider.Editor putString(@NonNull String key, @Nullable String value) {
            this._wrapper.mStrings.put(key, value);
            this._editor_editor.putString(key, value);
            return this;
        }

        @Override
        public IPreferencesProvider.Editor putLong(@NonNull String key, long value) {
            this._wrapper.mLongs.put(key, value);
            this._editor_editor.putLong(key, value);
            return this;
        }

        @Override
        public IPreferencesProvider.Editor putBoolean(@NonNull String key, boolean value) {
            this._wrapper.mBooleans.put(key, value);
            this._editor_editor.putBoolean(key, value);
            return this;
        }

        @Override
        public IPreferencesProvider.Editor putInt(@NonNull String key, int value) {
            this._wrapper.mInts.put(key, value);
            this._editor_editor.putInt(key, value);
            return this;
        }

        @Override
        public void apply() {
            this._editor_editor.apply();
            this._editor_editor.commit();
        }
    }
}

