/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.utils;

import android.support.annotation.NonNull;
import com.voxeet.android.media.MediaStreamType;

public class PeerInformation {
    private static final MediaStreamType[] TYPES = new MediaStreamType[]{MediaStreamType.Camera, MediaStreamType.ScreenShare, MediaStreamType.Custom1, MediaStreamType.Custom2, MediaStreamType.Custom3, MediaStreamType.Custom4, MediaStreamType.Custom5, MediaStreamType.Custom6, MediaStreamType.Custom7, MediaStreamType.Custom8};
    public String index = "0";
    public String type = "camera";
    public String peerId;
    public MediaStreamType calculatedMediaStreamType;

    public PeerInformation(@NonNull String formatted, MediaStreamType originalCallbackOrigin) {
        String[] split = formatted.split("_");
        if (split.length == 3) {
            this.index = split[0];
            this.type = split[1];
            this.peerId = split[2];
            this.calculatedMediaStreamType = this.from(this.index);
        } else {
            this.index = Integer.toString(originalCallbackOrigin.ordinal());
            this.type = originalCallbackOrigin.name().toLowerCase();
            this.peerId = formatted;
            this.calculatedMediaStreamType = originalCallbackOrigin;
        }
    }

    @NonNull
    private MediaStreamType from(@NonNull String originalIndex) {
        int index = 0;
        try {
            index = Integer.parseInt(originalIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (index >= 0 && index < TYPES.length) {
            return TYPES[index];
        }
        return TYPES[0];
    }
}

