/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.network.endpoints.ISdkVideoPresentationRService;
import com.voxeet.sdk.core.services.abstracts.AbstractPresentationService;
import com.voxeet.sdk.core.services.presentation.PresentationState;
import com.voxeet.sdk.core.services.presentation.video.VideoPresentation;
import com.voxeet.sdk.json.VideoPresentationPaused;
import com.voxeet.sdk.json.VideoPresentationPlay;
import com.voxeet.sdk.json.VideoPresentationSeek;
import com.voxeet.sdk.json.VideoPresentationStarted;
import com.voxeet.sdk.json.VideoPresentationStopped;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import retrofit2.Call;

@Annotate
public class VideoPresentationService
extends AbstractPresentationService<ISdkVideoPresentationRService, VideoPresentation> {
    private List<Solver<VideoPresentation>> mCacheStartedSolvers;
    private List<Solver<VideoPresentation>> mCacheStoppedSolvers;
    private List<Solver<VideoPresentation>> mCachePausedSolvers = new ArrayList<Solver<VideoPresentation>>();
    private List<Solver<VideoPresentation>> mCachePlaySolvers;
    private List<Solver<VideoPresentation>> mCacheSeekSolvers;

    @NoDocumentation
    public VideoPresentationService(VoxeetSdk instance) {
        super(instance, ISdkVideoPresentationRService.class);
        this.mCacheStartedSolvers = new ArrayList<Solver<VideoPresentation>>();
        this.mCacheStoppedSolvers = new ArrayList<Solver<VideoPresentation>>();
        this.mCachePausedSolvers = new ArrayList<Solver<VideoPresentation>>();
        this.mCachePlaySolvers = new ArrayList<Solver<VideoPresentation>>();
        this.mCacheSeekSolvers = new ArrayList<Solver<VideoPresentation>>();
        this.registerEventBus();
    }

    void onInternalServiceEvent(VideoPresentationStarted event) {
        VideoPresentation information = this.getPresentationInformation(event.key);
        information.url = event.url;
        this.presentations.add(information);
        information.state = PresentationState.STARTED;
        information.lastSeekTimestamp = event.timestamp;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information, this.mCacheStartedSolvers);
    }

    void onInternalServiceEvent(VideoPresentationStopped event) {
        VideoPresentation information = this.getPresentationInformation(event.key);
        information.state = PresentationState.STOP;
        this.presentations.remove(information);
        this.getEventBus().post((Object)event);
        this.tryUnlock(information, this.mCacheStoppedSolvers);
    }

    void onInternalServiceEvent(VideoPresentationPaused event) {
        VideoPresentation information = this.getPresentationInformation(event.key);
        information.state = PresentationState.PAUSED;
        information.lastSeekTimestamp = event.timestamp;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information, this.mCachePausedSolvers);
    }

    void onInternalServiceEvent(VideoPresentationPlay event) {
        VideoPresentation information = this.getPresentationInformation(event.key);
        information.state = PresentationState.PLAY;
        information.lastSeekTimestamp = event.timestamp;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information, this.mCachePlaySolvers);
    }

    void onInternalServiceEvent(VideoPresentationSeek event) {
        VideoPresentation information = this.getPresentationInformation(event.key);
        information.state = PresentationState.SEEK;
        information.lastSeekTimestamp = event.timestamp;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information, this.mCacheSeekSolvers);
    }

    @NonNull
    public Promise<VideoPresentation> startVideoPresentation(final String url) {
        return new Promise<VideoPresentation>(new PromiseSolver<VideoPresentation>(){

            @Override
            public void onCall(@NonNull Solver<VideoPresentation> solver) {
                ISdkVideoPresentationRService.VideoPresentationUrl holder = new ISdkVideoPresentationRService.VideoPresentationUrl(url);
                VideoPresentationService.this.consumeInternalCall(solver, VideoPresentationService.this.mCacheStartedSolvers, VideoPresentationService.this.internalCall((Call<ResponseBody>)((ISdkVideoPresentationRService)VideoPresentationService.this.getService()).startVideoPresentation(VideoPresentationService.this.getConferenceId(), holder)));
            }
        });
    }

    @NonNull
    public Promise<VideoPresentation> stopVideoPresentation() {
        return new Promise<VideoPresentation>(new PromiseSolver<VideoPresentation>(){

            @Override
            public void onCall(@NonNull Solver<VideoPresentation> solver) {
                VideoPresentationService.this.consumeInternalCall(solver, VideoPresentationService.this.mCacheStoppedSolvers, VideoPresentationService.this.internalCall((Call<ResponseBody>)((ISdkVideoPresentationRService)VideoPresentationService.this.getService()).stopVideoPresentation(VideoPresentationService.this.getConferenceId())));
            }
        });
    }

    @NonNull
    public Promise<VideoPresentation> playVideoPresentation() {
        return new Promise<VideoPresentation>(new PromiseSolver<VideoPresentation>(){

            @Override
            public void onCall(@NonNull Solver<VideoPresentation> solver) {
                VideoPresentationService.this.consumeInternalCall(solver, VideoPresentationService.this.mCachePlaySolvers, VideoPresentationService.this.internalCall((Call<ResponseBody>)((ISdkVideoPresentationRService)VideoPresentationService.this.getService()).playVideoPresentation(VideoPresentationService.this.getConferenceId())));
            }
        });
    }

    @NonNull
    public Promise<VideoPresentation> pauseVideoPresentation(final long timestamp) {
        return new Promise<VideoPresentation>(new PromiseSolver<VideoPresentation>(){

            @Override
            public void onCall(@NonNull Solver<VideoPresentation> solver) {
                ISdkVideoPresentationRService.VideoPresentationSeek body_sent = new ISdkVideoPresentationRService.VideoPresentationSeek(timestamp);
                VideoPresentationService.this.consumeInternalCall(solver, VideoPresentationService.this.mCachePausedSolvers, VideoPresentationService.this.internalCall((Call<ResponseBody>)((ISdkVideoPresentationRService)VideoPresentationService.this.getService()).pauseVideoPresentation(VideoPresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }

    @NonNull
    public Promise<VideoPresentation> seekVideoPresentation(final long timestamp) {
        return new Promise<VideoPresentation>(new PromiseSolver<VideoPresentation>(){

            @Override
            public void onCall(@NonNull Solver<VideoPresentation> solver) {
                ISdkVideoPresentationRService.VideoPresentationSeek body_sent = new ISdkVideoPresentationRService.VideoPresentationSeek(timestamp);
                VideoPresentationService.this.consumeInternalCall(solver, VideoPresentationService.this.mCacheSeekSolvers, VideoPresentationService.this.internalCall((Call<ResponseBody>)((ISdkVideoPresentationRService)VideoPresentationService.this.getService()).seekVideoPresentation(VideoPresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }

    @Nullable
    public VideoPresentation getCurrentPresentation() {
        for (VideoPresentation information : this.presentations) {
            if (PresentationState.STOP.equals(information)) continue;
            return information.clone();
        }
        return null;
    }

    @NonNull
    private VideoPresentation getPresentationInformation(@NonNull String key) {
        for (VideoPresentation information : this.presentations) {
            if (!key.equals(information.key)) continue;
            return information;
        }
        return new VideoPresentation(key, "");
    }
}

