package com.voxeet.sdk.models.v1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Meeting implements Comparable<Meeting> {

    private String meetingId;

    private String meetingType;

    @JsonProperty("readTimestamp")
    private long lastRead;

    private int nbSharedFile;

    private List<String> tags;

    @JsonProperty("notificationType")
    private String settings;

    private List<UserProfile> profiles;

    private List<MeetingEvent> events;

    @JsonProperty("conferenceInfo")
    private ConferenceInfos conferenceInfos;

    public long getLastEventTime() {
        return lastEventTime;
    }

    public void setLastEventTime(long lastEventTime) {
        this.lastEventTime = lastEventTime;
    }

    private long lastEventTime;

    //TODO reminiscence from RealmObject isValid() - remove ?
    public boolean isObjectValid() {
        return true;
    }

    public List<MeetingEvent> getEvents() {
        List<? extends MeetingEvent> events = this.events;
        return (List<MeetingEvent>) events;
    }

    public void setEvents(List<MeetingEvent> events) {
        this.events = events;
    }

    public ConferenceInfos getConferenceInfos() {
        return conferenceInfos;
    }

    public void setConferenceInfos(ConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    public int getNbSharedFile() {
        return nbSharedFile;
    }

    public void setNbSharedFile(int nbSharedFile) {
        this.nbSharedFile = nbSharedFile;
    }

    public List<String> getTags() {
        if (tags == null)
            return null;

        List<String> list = new ArrayList<>();
        list.addAll(tags);
        return list;
    }

    public void setTags(List<String> tags) {
        if (tags != null) {
            if (this.tags == null)
                this.tags = new ArrayList<>();
            else
                this.tags.clear();

            this.tags.addAll(tags);
        }
    }

    public String getSettings() {
        return settings;
    }

    public void setSettings(String settings) {
        this.settings = settings;
    }

    public String getMeetingId() {
        return meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public String getMeetingType() {
        return meetingType;
    }

    public void setMeetingType(String meetingType) {
        this.meetingType = meetingType;
    }

    public long getLastRead() {
        return lastRead;
    }

    public void setLastRead(long lastRead) {
        this.lastRead = lastRead;
    }

    public List<UserProfile> getProfiles() {
        return profiles;
    }

    public void setProfiles(List<UserProfile> profiles) {
        this.profiles = profiles;
    }

    public MeetingEvent lastEvent() { //reverse order
        try {
            return events.get(0);
        } catch (ArrayIndexOutOfBoundsException | NoSuchElementException e) {
            return null;
        }
    }

    public String title() {
        boolean isFirst = true;
        String names = "";
        for (UserProfile p : profiles) {
            if (isFirst) {
                names += p.getNickName();
                isFirst = false;
            } else {
                names += ", " + p.getNickName();
            }
        }
        return names;
    }

    public String name() {
        String name = null;
        if (tags != null && tags.size() > 0) {
            name = "#";
            int i = 0;
            for (String tag : tags) {
                if (null != tag) {
                    if (i > 0) name += " ";
                    name += tag;
                }
            }
        }
        return name;
    }

    public void sort() {
        Collections.sort(events);

        lastEventTime = lastEvent().getTime();
    }

    public MeetingEvent getLastMeetingEvent() {
        if (events.size() > 0)
            return events.get(events.size() - 1);
        return null;
    }

    @Override
    public int compareTo(Meeting another) {
        return new Date(another.lastEvent().getTime()).compareTo(new Date(lastEvent().getTime()));
    }
}
