package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.MetaData;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.ToDelete;

import java.util.ArrayList;
import java.util.List;

@Annotate
@ToDelete
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.SDK_CONFERENCE_ENDED)
public class SdkConferenceEnded extends Event {

    private String conferenceId;

    private long duration;

    private long startTime;

    private String ownerId;

    private List<MetaData> users = new ArrayList<>();

    public SdkConferenceEnded() {
    }

    public long getDuration() { return duration; }

    public void setDuration(long duration) { this.duration = duration; }

    public List<MetaData> getUsers() { return users; }

    public void setUsers(List<MetaData> users) { this.users = users; }

    public SdkConferenceEnded(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public String getOwnerId() { return ownerId; }

    public void setOwnerId(String ownerId) { this.ownerId = ownerId; }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public String getType() {
        return EventNames.SDK_CONFERENCE_ENDED;
    }
}
