package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

import java.util.List;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.QUALITY_UPDATED)
public class QualityUpdated extends Event {

    @JsonProperty("conference_id")
    private String conferenceId;

    @JsonProperty("quality_indicators")
    private List<ConferenceUser> user;

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public List<ConferenceUser> getUser() {
        return user;
    }

    public void setUser(List<ConferenceUser> user) {
        this.user = user;
    }

    @Override
    public String getType() {
        return EventNames.QUALITY_UPDATED;
    }
}
