package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.UserProfile;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.CONTACT_PROFILE_UPDATED)
public class ProfileUpdatedEvent extends Event {

    public UserProfile profile;

    @Override
    public String getType() {
        return EventNames.CONTACT_PROFILE_UPDATED;
    }
}
