package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.InvitedContact;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

import java.util.List;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.OWN_EXTERNAL_INVITATION)
public class OwnExternalInvitationSentEvent extends Event {

    public String userId;

    @JsonProperty("externalRequestedEvents")
    public List<InvitedContact> contacts;

    @Override
    public String getType() {
        return EventNames.OWN_EXTERNAL_INVITATION;
    }
}
