package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.Conference;
import com.voxeet.sdk.models.v1.Invitation;
import com.voxeet.sdk.models.v1.UserProfile;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;

import java.util.List;

@InternalEvent
@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.INVITATION_RECEIVED)
public class InvitationReceivedEvent extends Event {

    private UserInviter inviter;

    private String userId;

    private String conferenceId;

    private String meetingId;

    private UserProfile ownerProfile;

    private String title;

    private String description;

    private List<Invitation> invitations;

    private String conferenceHost;

    private String conferencePort;

    private String conferenceSecurityToken;

    @JsonProperty("conferenceInfo")
    private Conference conference;

    public List<Invitation> getInvitations() {
        return invitations;
    }

    public void setInvitations(List<Invitation> invitations) {
        this.invitations = invitations;
    }

    public String getConferenceHost() {
        return conferenceHost;
    }

    public void setConferenceHost(String conferenceHost) {
        this.conferenceHost = conferenceHost;
    }

    public String getConferencePort() {
        return conferencePort;
    }

    public void setConferencePort(String conferencePort) {
        this.conferencePort = conferencePort;
    }

    public String getConferenceSecurityToken() {
        return conferenceSecurityToken;
    }

    public void setConferenceSecurityToken(String conferenceSecurityToken) {
        this.conferenceSecurityToken = conferenceSecurityToken;
    }

    public Conference getConference() {
        return conference;
    }

    public void setConference(Conference conference) {
        this.conference = conference;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getMeetingId() {
        return meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public UserProfile getOwnerProfile() {
        return ownerProfile;
    }

    public void setOwnerProfile(UserProfile ownerProfile) {
        this.ownerProfile = ownerProfile;
    }

    @Override
    public String getType() {
        return EventNames.INVITATION_RECEIVED;
    }

    public UserInviter getInviter() {
        return inviter;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public class UserInviter {

        public String userId;

        public String externalId;

        public String externalAvatarUrl;

        public String nickName;


        /*
        "proVersion" : null,
        "city" : null,
        "timezone" : null,
        "firstName" : null,
        "lastName" : null,
        "photoId" : null,
        "userId" : null,
        "mailLocalPartId" : null,
        "selectedNodeSetAsString" : null,
        "login" : null,
        "profileType" : null,
        "statusPhrase" : null,
        "nickName" : null,
        "locale" : null,
        "jobTitle" : null,
        "company" : null,
        "creationUtcTimestamp" : 0,
        "externalAvatarUrl" : null,
        "externalId" : null,
        "updateUtcTimestamp" : 0,
        "mailLocalPart" : null,
        "country" : null,
        "manager" : null,
        "profileIdAsString" : null,
        "proTeamVersion" : null,
        "pstnSelectedNodeSet" : null,
        "mailLocalPartWithId" : null,
        "pro" : null
         */
    }
}
