package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

@Annotate
@FromWebsocket
@JsonTypeName(EventNames.BROADCAST_EVENT)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BroadcastEvent extends Event {

    @JsonProperty("message")
    public String message;

    @JsonProperty("from")
    public String userId;

    public String meetingId;

    public BroadcastEvent() {

    }

    public BroadcastEvent(String message) {
        this.message = message;
    }

    @Override
    public String getType() {
        return EventNames.BROADCAST_EVENT;
    }
}
