package com.voxeet.sdk.factories;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.WindowManager;

import java.util.Map;

public class VoxeetIntentFactory {

    public static final String NOTIF_TYPE_INVITATION_RECEIVED = "1";
    public static final String NOTIF_TYPE_CONTACT_SUBSCRIPTION_RECEIVED = "2";
    public static final String NOTIF_TYPE_OWN_EVENTS_CLEARED = "3";
    public static final String NOTIF_TYPE_OWN_ACTIVITIES_CLEARED = "4";
    public static final String NOTIF_TYPE_LOCAL_CONFERENCE_DESTROYED = "5";
    public static final String NOTIF_TYPE_OWN_CONFERENCE_CREATED = "6";
    public static final String NOTIF_TYPE_CONTACTS_SUGGESTION = "7";
    public static final String NOTIF_TYPE_MESSAGE_RECEIVED = "8";

    /**
     * Error message when failing to create activity class.
     */
    private final static String defaultError = "Default activity to be triggered when receiving a notification has not been set. Please use setPathToActivity() with the path of the desired activity.";

    /**
     * Get the class to implement from the saved activity
     *
     * @param path a valid or null class
     * @return a valid Class object or null if no class is to be used
     */
    @Nullable
    public static Class<?> createClass(@Nullable String path) {
        if (path == null)
            throw new IllegalStateException(defaultError);

        try {
            return Class.forName(path);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}
