package com.voxeet.sdk.factories;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.sdk.json.Event;

import java.io.IOException;

public class EventsFactory {
    private static final String TAG = EventsFactory.class.getSimpleName();

    private static ObjectMapper objectMapper = new ObjectMapper();

    private EventsFactory() {

    }

    @Nullable
    public static <T> T mapping(String message, Class<T> klass) {

        try {
            return objectMapper.readValue(message, klass);
        } catch (IOException e) {
            Log.e(Event.TAG, "failed to decode command", e);
            return null;
        }
    }

    @Nullable
    public static Event decode(String message) {
        try {
            Event event = objectMapper.readValue(message, Event.class);
            Log.d(TAG, "decode: event := " + event.getType());
            return event;
        } catch (IOException e) {
            Log.e(Event.TAG, "failed to decode command", e);
            return null;
        }
    }

    @Nullable
    public static String getJson(@NonNull Object event) {
        ObjectMapper om = new ObjectMapper();
        try {
            return om.writeValueAsString(event);
        } catch (JsonProcessingException e) {
            Log.e(TAG, "failed to send command", e);
            return null;
        }
    }


}
