/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.models.v1.Conference;
import com.voxeet.sdk.models.v1.ConferenceInfos;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.models.v1.UserProfile;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="OwnUserInvitedEvent")
public class OwnUserInvited
extends Event {
    private String userId;
    @JsonProperty(value="conference")
    private ConferenceInfos conferenceInfos;
    private List<UserProfile> guests;

    public List<UserProfile> getGuests() {
        return this.guests;
    }

    public void setGuests(List<UserProfile> guests) {
        this.guests = guests;
    }

    public Conference getConference() {
        Conference conference = new Conference();
        conference.setConferenceInfos(this.conferenceInfos);
        conference.setHasBeenCreated(true);
        conference.setDemo(false);
        conference.setConferenceType(this.conferenceInfos.getConferenceType());
        conference.setMeetingId(this.conferenceInfos.getMeetingId());
        conference.setConferenceId(this.conferenceInfos.getConferenceId());
        conference.setDescription(this.conferenceInfos.getDescription());
        conference.setLocation(this.conferenceInfos.getLocation());
        conference.setGuestAccess(false);
        conference.setOffline(false);
        conference.setRecorded(false);
        conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);
        for (UserProfile profile : this.guests) {
            conference.getConferenceUsers().add(new ConferenceUser(profile));
        }
        return conference;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ConferenceInfos getConferenceInfos() {
        return this.conferenceInfos;
    }

    public void setConferenceInfos(ConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Override
    public String getType() {
        return "OwnUserInvitedEvent";
    }
}

