/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.factories;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.util.Map;

public class VoxeetIntentFactory {
    public static final String NOTIF_TYPE_INVITATION_RECEIVED = "1";
    public static final String NOTIF_TYPE_CONTACT_SUBSCRIPTION_RECEIVED = "2";
    public static final String NOTIF_TYPE_OWN_EVENTS_CLEARED = "3";
    public static final String NOTIF_TYPE_OWN_ACTIVITIES_CLEARED = "4";
    public static final String NOTIF_TYPE_LOCAL_CONFERENCE_DESTROYED = "5";
    public static final String NOTIF_TYPE_OWN_CONFERENCE_CREATED = "6";
    public static final String NOTIF_TYPE_CONTACTS_SUGGESTION = "7";
    public static final String NOTIF_TYPE_MESSAGE_RECEIVED = "8";
    private static final String defaultError = "Default activity to be triggered when receiving a notification has not been set. Please use setPathToActivity() with the path of the desired activity.";
    public static final String CONF_ID = "ConfId";
    public static final String INVITER_NAME = "DisplayName";
    public static final String INVITER_EXTERNAL_ID = "ExternalId";
    public static final String INVITER_ID = "UserId";
    public static final String INVITER_URL = "AvatarUrl";
    public static final String NOTIF_TYPE = "NotifType";
    public static final String[] DEFAULT_NOTIFICATION_KEYS = new String[]{"UserId", "DisplayName", "NotifType", "ExternalId", "AvatarUrl", "ConfId"};
    private static final String TAG = VoxeetIntentFactory.class.getSimpleName();

    @Nullable
    private static Class<?> createClass(@Nullable String path) {
        if (path == null) {
            throw new IllegalStateException(defaultError);
        }
        try {
            return Class.forName(path);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Intent buildFrom(@NonNull Context context, @Nullable String path, @NonNull Map<String, String> data) {
        Class<?> newClass = VoxeetIntentFactory.createClass(path);
        Log.d((String)TAG, (String)("buildFrom: class found to start with := " + newClass + " (-> must not be nulled!)"));
        for (String string2 : data.keySet()) {
            Log.d((String)TAG, (String)("buildFrom: " + string2 + " " + data.get(string2)));
        }
        if (newClass != null) {
            Intent intent = new Intent();
            intent.setClass(context, newClass);
            for (String key : DEFAULT_NOTIFICATION_KEYS) {
                if (!data.containsKey(key)) continue;
                intent.putExtra(key, data.get(key));
            }
            intent.putExtra("join", true);
            intent.putExtra("callMode", 1);
            intent.addFlags(4);
            intent.addFlags(0x10000000);
            intent.addFlags(0x680080);
            return intent;
        }
        return null;
    }

    @Nullable
    public static Intent buildFrom(@NonNull Context context, @Nullable String path, @NonNull Bundle extra) {
        Class<?> newClass = VoxeetIntentFactory.createClass(path);
        if (newClass != null) {
            Intent intent = new Intent();
            intent.setClass(context, newClass);
            for (String key : DEFAULT_NOTIFICATION_KEYS) {
                if (!extra.containsKey(key)) continue;
                intent.putExtra(key, extra.getString(key));
            }
            intent.putExtra("join", true);
            intent.putExtra("callMode", 1);
            intent.addFlags(4);
            intent.addFlags(0x10000000);
            intent.addFlags(0x680080);
            return intent;
        }
        return null;
    }
}

