/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.AudioService;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.core.services.conference.information.ConferenceState;
import com.voxeet.sdk.core.services.conference.information.ConferenceUserType;
import com.voxeet.sdk.core.services.conference.information.LocalConferenceType;
import com.voxeet.sdk.models.Conference;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;

public class JoinPromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = JoinPromise.class.getSimpleName();
    private final String conferenceId;
    private final ConferenceUserType userType;
    private final VoxeetSdk instance;
    private AudioService audioService;

    public JoinPromise(@NonNull ConferenceService parent, @NonNull AudioService audioService, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull VoxeetSdk instance, @NonNull String conferenceId, @NonNull ConferenceUserType userType) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.audioService = audioService;
        this.instance = instance;
        this.conferenceId = conferenceId;
        this.userType = userType;
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        final Promise<Boolean> promise = new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                boolean init_done;
                JoinPromise.this.joinLock();
                ConferenceInformation information = JoinPromise.this.createOrSetConferenceWithParams(JoinPromise.this.conferenceId, null);
                information.setConferenceUserType(JoinPromise.this.userType);
                String currentConferenceId = JoinPromise.this.getParent().getConferenceId();
                ConferenceInformation holder = JoinPromise.this.getConferenceInformation(JoinPromise.this.conferenceId);
                boolean bl = init_done = null != holder && (ConferenceState.JOINING.equals((Object)holder.getConferenceState()) || ConferenceState.JOINED.equals((Object)holder.getConferenceState()));
                if (null != currentConferenceId && currentConferenceId.equals(JoinPromise.this.conferenceId) && init_done) {
                    Log.d((String)TAG, (String)("onCall: join the conference " + JoinPromise.this.conferenceId + " // invalid call ! already calling it"));
                    Log.d((String)TAG, (String)("onCall: btw, the current " + JoinPromise.this.conferenceId + " state is := " + (Object)((Object)holder.getConferenceState())));
                    solver.resolve(true);
                    JoinPromise.this.joinUnlock();
                    return;
                }
                JoinPromise.this.setIsInConference(true);
                Conference conference = holder.getConference();
                Log.d((String)TAG, (String)("Attempting to join conference alias:=" + conference.getAlias() + " conferenceId:=" + JoinPromise.this.conferenceId));
                Log.d((String)TAG, (String)"onNext: having conference");
                JoinPromise.this.audioService.enable();
                information.setConferenceState(ConferenceState.JOINING);
                information.setConferenceType(LocalConferenceType.CONFERENCE);
                information.setTelecomMode(JoinPromise.this.getParent().isTelecomMode());
                Log.d((String)TAG, (String)("onNext: join with := " + conference.getId() + " " + conference.getAlias()));
                JoinPromise.this.joinUnlock();
                JoinPromise.this.setCurrentConferenceIfNotInPreviousConference(information);
                JoinPromise.this.joinConference(information).then(new PromiseExec<Boolean, Object>(){

                    @Override
                    public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                        solver.resolve(result);
                    }
                }).error(new ErrorPromise(){

                    @Override
                    public void onError(Throwable error) {
                        error.printStackTrace();
                        solver.resolve(false);
                    }
                });
            }
        });
        if (VoxeetSdk.session().isSocketOpen()) {
            return promise;
        }
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                Log.d((String)TAG, (String)"onCall: joining but the socket is disconnected");
                VoxeetSdk.session().open().then(new PromiseExec<Boolean, Object>(){

                    @Override
                    public void onCall(@Nullable Boolean result, @NonNull Solver internal_solver) {
                        Log.d((String)TAG, (String)("onCall: connection ? " + result));
                        promise.then(new PromiseExec<Boolean, Object>(){

                            @Override
                            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                                Log.d((String)TAG, (String)("onCall: join ok? " + result));
                                solver.resolve(result);
                            }
                        }).error(new ErrorPromise(){

                            @Override
                            public void onError(@NonNull Throwable error) {
                                Log.d((String)TAG, (String)"onError: join ko");
                                solver.reject(error);
                            }
                        });
                    }
                }).error(new ErrorPromise(){

                    @Override
                    public void onError(@NonNull Throwable error) {
                        solver.reject(error);
                    }
                });
            }
        });
    }
}

