/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.core.services.conference.information.ConferenceState;
import com.voxeet.sdk.core.services.conference.information.LocalConferenceType;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.sdk.ConferenceStateEvent;
import com.voxeet.sdk.json.CreateConferenceParams;
import com.voxeet.sdk.json.internal.MetadataHolder;
import com.voxeet.sdk.json.internal.ParamsHolder;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.v1.CreateConferenceResult;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class CreateConferencePromiseable
extends AbstractPromiseable<CreateConferenceResult> {
    private String conferenceAlias;
    private MetadataHolder metadata;
    private ParamsHolder params = null;

    public CreateConferencePromiseable(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @Nullable String conferenceAlias, @Nullable MetadataHolder metadata, @Nullable ParamsHolder params) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.conferenceAlias = conferenceAlias;
        this.metadata = metadata;
        this.params = params;
    }

    @Override
    @NonNull
    public Promise<CreateConferenceResult> createPromise() {
        final Promise<CreateConferenceResult> promise = new Promise<CreateConferenceResult>(new PromiseSolver<CreateConferenceResult>(){

            @Override
            public void onCall(@NonNull Solver<CreateConferenceResult> solver) {
                CreateConferencePromiseable.this.getEventBus().post((Object)new ConferenceStateEvent(CreateConferencePromiseable.this.conferenceAlias, ConferenceState.CREATING));
                CreateConferencePromiseable.this.log("Attempting to create mConferene alias:=" + CreateConferencePromiseable.this.conferenceAlias);
                CreateConferenceParams arg = new CreateConferenceParams().setMetadataHolder(CreateConferencePromiseable.this.metadata).setParamsHolder(CreateConferencePromiseable.this.params);
                if (null != CreateConferencePromiseable.this.conferenceAlias) {
                    arg.setConferenceAlias(CreateConferencePromiseable.this.conferenceAlias);
                }
                CreateConferencePromiseable.this.internalCreate(true, arg, solver);
            }
        });
        if (VoxeetSdk.session().isSocketOpen()) {
            return promise;
        }
        return new Promise<CreateConferenceResult>(new PromiseSolver<CreateConferenceResult>(){

            @Override
            public void onCall(final @NonNull Solver<CreateConferenceResult> solver) {
                VoxeetSdk.session().open().then(new PromiseExec<Boolean, Object>(){

                    @Override
                    public void onCall(@Nullable Boolean result, @NonNull Solver internal_solver) {
                        promise.then(new PromiseExec<CreateConferenceResult, Object>(){

                            @Override
                            public void onCall(@Nullable CreateConferenceResult result, @NonNull Solver<Object> internal_solver) {
                                solver.resolve(result);
                            }
                        }).error(new ErrorPromise(){

                            @Override
                            public void onError(@NonNull Throwable error) {
                                solver.reject(error);
                            }
                        });
                    }
                }).error(new ErrorPromise(){

                    @Override
                    public void onError(@NonNull Throwable error) {
                        solver.reject(error);
                    }
                });
            }
        });
    }

    private void internalCreate(final boolean retry, final CreateConferenceParams params, final Solver<CreateConferenceResult> solver) {
        Call<CreateConferenceResult> observable = this.getProvider().getCreateConferenceObservable(params);
        HttpHelper.enqueue(observable, new HttpHelper.HttpCallback<CreateConferenceResult>(){

            @Override
            public void onSuccess(@NonNull CreateConferenceResult object, @NonNull Response<CreateConferenceResult> response) {
                CreateConferencePromiseable.this.log("onNext: having conference");
                ConferenceInformation information = CreateConferencePromiseable.this.createOrSetConferenceWithParams(object.conferenceId, object.conferenceAlias);
                information.setConferenceState(ConferenceState.CREATED);
                information.setConferenceType(LocalConferenceType.CONFERENCE);
                Conference conference = information.getConference();
                CreateConferencePromiseable.this.getEventBus().post((Object)new ConferenceStateEvent(conference, conference.getState()));
                CreateConferencePromiseable.this.log("internalCreate onNext: join with := " + object.conferenceId + " " + object.conferenceAlias);
                information.getConference().setConferenceId(object.conferenceId);
                CreateConferencePromiseable.this.log("now conference is " + information.getConference().getId());
                solver.resolve(object);
            }

            @Override
            public void onFailure(@NonNull Throwable e, @Nullable Response<CreateConferenceResult> response) {
                HttpException.dumpErrorResponse(response);
                e.printStackTrace();
                if (!retry) {
                    CreateConferencePromiseable.this.log("internalCreate onFailure: conference creation failed ! but no retry... quit...");
                    CreateConferencePromiseable.this.setIsInConference(false);
                    CreateConferencePromiseable.this.closeMedia();
                    CreateConferencePromiseable.this.getEventBus().post((Object)new ConferenceStateEvent(params.conferenceAlias, ConferenceState.CREATED_ERROR));
                    solver.reject(e);
                } else {
                    CreateConferencePromiseable.this.log("internalCreate onFailure: conference creation failed ! but retry... now...");
                    CreateConferencePromiseable.this.internalCreate(false, params, solver);
                }
            }
        });
    }
}

