/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.conference.information;

import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.sdk.core.services.conference.information.ConferenceState;
import com.voxeet.sdk.core.services.conference.information.ConferenceUserType;
import com.voxeet.sdk.core.services.conference.information.LocalConferenceType;
import com.voxeet.sdk.media.audio.UserPosition;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.Participant;
import com.voxeet.sdk.utils.Annotate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Annotate
public class ConferenceInformation {
    private static final String TAG = ConferenceInformation.class.getSimpleName();
    @NonNull
    private Conference mConference;
    @NonNull
    private Map<String, String> mUserIdsCached;
    private LocalConferenceType mConferenceType;
    @NonNull
    private List<User> mLastInvitationReceived;
    private ConferenceState state = ConferenceState.DEFAULT;
    private HashMap<String, UserPosition> mPositions;
    private boolean mOwnScreenShareStarted = false;
    private boolean mOwnVideoStarted = false;
    private ConferenceUserType mUserType = ConferenceUserType.NORMAL;
    private boolean telecomMode = false;

    private ConferenceInformation() {
        this.mUserIdsCached = new HashMap<String, String>();
        this.mLastInvitationReceived = new ArrayList<User>();
        this.mConference = new Conference(this);
        this.mConferenceType = LocalConferenceType.NONE;
        this.mPositions = new HashMap();
    }

    public ConferenceInformation(@NonNull User localUser, @NonNull String conferenceId) {
        this();
        this.mConference.updateUser(localUser);
        this.mConference.setConferenceId(conferenceId);
    }

    @NonNull
    public UserPosition getPosition(@NonNull ConferenceUser user) {
        return this.getPosition(user.getUserId());
    }

    @NonNull
    public UserPosition getPosition(@NonNull String userId) {
        UserPosition p = this.mPositions.get(userId);
        if (null == p) {
            p = new UserPosition(0.0, 0.0);
        }
        return p;
    }

    public void setPosition(@NonNull ConferenceUser user, @NonNull UserPosition point) {
        this.setPosition(user.getUserId(), point);
    }

    public void setPosition(@NonNull String userId, @NonNull UserPosition point) {
        this.mPositions.put(userId, point);
    }

    @NonNull
    public Conference getConference() {
        return this.mConference;
    }

    public void setConference(@NonNull Conference conference) {
        this.mConference = conference;
    }

    public void setConferenceType(@NonNull LocalConferenceType type) {
        this.mConferenceType = type;
    }

    @NonNull
    public LocalConferenceType getConferenceType() {
        return this.mConferenceType;
    }

    @Deprecated
    @NonNull
    public Map<String, String> getUserIdsCached() {
        return this.mUserIdsCached;
    }

    @Deprecated
    @NonNull
    public List<User> getLastInvitationReceived() {
        return this.mLastInvitationReceived;
    }

    public void setConferenceState(@NonNull ConferenceState state) {
        this.state = state;
    }

    @NonNull
    public ConferenceState getConferenceState() {
        return this.state;
    }

    public void setOwnVideoStarted(boolean ownVideoStarted) {
        Log.d((String)TAG, (String)("setOwnVideoStarted: " + ownVideoStarted));
        this.mOwnVideoStarted = ownVideoStarted;
    }

    public boolean isOwnVideoStarted() {
        Log.d((String)TAG, (String)("isOwnVideoStarted: " + this.mOwnVideoStarted));
        return this.mOwnVideoStarted;
    }

    public void setConferenceUserType(@NonNull ConferenceUserType userType) {
        this.mUserType = userType;
    }

    public ConferenceUserType getConferenceUserType() {
        return this.mUserType;
    }

    public boolean isBroadcaster() {
        return ConferenceUserType.BROADCASTER.equals((Object)this.mUserType);
    }

    public boolean isListener() {
        return ConferenceUserType.LISTENER.equals((Object)this.mUserType);
    }

    public void setLocalUserType(ConferenceUserType userType) {
        this.mUserType = userType;
    }

    public void setScreenShareOn(boolean enable) {
        this.mOwnScreenShareStarted = enable;
    }

    public boolean isScreenShareOn() {
        return this.mOwnScreenShareStarted;
    }

    public void participantsToConferenceUsers(List<Participant> participants) {
        if (null != participants) {
            Map<String, String> cache = this.getUserIdsCached();
            for (Participant participant : participants) {
                cache.put(participant.getExternalId(), participant.getExternalId());
            }
            Conference conference = this.getConference();
            conference.updateParticipants(participants);
        }
    }

    public void setTelecomMode(boolean telecomMode) {
        this.telecomMode = telecomMode;
    }

    public boolean isTelecomMode() {
        return this.telecomMode;
    }

    public void clean() {
        this.mPositions.clear();
        this.mConference.getUsers().clear();
    }

    public String toString() {
        return "ConferenceInformation{Conference='" + this.mConference + '\'' + '}';
    }
}

