/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v2.ChatMessage;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InternalChatMessage {
    public String title;
    public String content;
    public String type;
    public String avatarUrl;
    public Date time;
    public String name;
    public String ownerId;

    public InternalChatMessage(String messageType, @Nullable User user, @NonNull ChatMessage chatMessage) {
        this.title = messageType;
        this.content = chatMessage.content;
        this.type = chatMessage.type.text();
        this.time = chatMessage.date;
        if (null != user) {
            this.ownerId = user.getId();
            UserInfo userInfo = user.getUserInfo();
            if (null != userInfo) {
                this.avatarUrl = userInfo.getAvatarUrl();
                this.name = userInfo.getName();
            }
        }
    }
}

