/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.network.endpoints.ISdkFilePresentationRService;
import com.voxeet.sdk.core.services.abstracts.AbstractPresentationService;
import com.voxeet.sdk.core.services.presentation.PresentationState;
import com.voxeet.sdk.core.services.presentation.file.FilePresentation;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.json.FileConverted;
import com.voxeet.sdk.json.FilePresentationStarted;
import com.voxeet.sdk.json.FilePresentationStopped;
import com.voxeet.sdk.json.FilePresentationUpdated;
import com.voxeet.sdk.models.v1.FilePresentationConverted;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Annotate
public class FilePresentationService
extends AbstractPresentationService<ISdkFilePresentationRService, FilePresentation> {
    private static final String TAG = FilePresentationService.class.getSimpleName();
    private HashMap<String, Solver<FilePresentation>> mCacheSolvers = new HashMap();
    private HashMap<String, Solver<FilePresentation>> mCacheStartedSolvers = new HashMap();
    private HashMap<String, Solver<FilePresentation>> mCacheStoppedSolvers = new HashMap();
    private HashMap<String, Solver<FilePresentation>> mCacheUpdatedSolvers = new HashMap();

    @NoDocumentation
    public FilePresentationService(VoxeetSdk instance) {
        super(instance, ISdkFilePresentationRService.class);
        this.registerEventBus();
    }

    void onInternalServiceEvent(FileConverted event) {
        List<com.voxeet.sdk.models.v1.File> list = event.getFiles();
        for (com.voxeet.sdk.models.v1.File file : list) {
            String key = this.findSolverFor(file.getName());
            if (null == key) continue;
            this.onInternalServiceEvent(new FilePresentationConverted(file.getName(), file.getFileId(), file.getSize(), file.getNbImageConverted()));
        }
    }

    void onInternalServiceEvent(FilePresentationConverted event) {
        FilePresentation information = this.getPresentationInformation(event.fileId);
        this.presentations.add(information);
        information.state = PresentationState.CONVERTED;
        information.page = 0;
        information.nbPage = event.nbImageConverted;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information.key, information, this.mCacheSolvers);
    }

    void onInternalServiceEvent(FilePresentationStarted event) {
        FilePresentation information = this.getPresentationInformation(event.fileId);
        this.presentations.add(information);
        information.state = PresentationState.STARTED;
        information.page = event.position;
        information.nbPage = event.imageCount;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information.key, information, this.mCacheSolvers);
    }

    void onInternalServiceEvent(FilePresentationUpdated event) {
        FilePresentation information = this.getPresentationInformation(event.fileId);
        this.presentations.add(information);
        information.state = PresentationState.SEEK;
        information.page = event.position;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information.key, information, this.mCacheSolvers);
    }

    void onInternalServiceEvent(FilePresentationStopped event) {
        FilePresentation information = this.getPresentationInformation(event.fileId);
        this.presentations.add(information);
        information.state = PresentationState.STOP;
        this.getEventBus().post((Object)event);
        this.tryUnlock(information.key, information, this.mCacheSolvers);
    }

    public String getImage(String fileId, int pageNumber) {
        return String.format(Locale.getDefault(), "%s/v1/files/%s/converted/%d?token=%s", this.getURLRoot(this.getVoxeetSdkInstance()), fileId, pageNumber, this.getInternalJwtToken(this.getVoxeetSdkInstance()));
    }

    public String getThumbnail(String fileId, int pageNumber) {
        return String.format(Locale.getDefault(), "%s/v1/files/%s/converted/%d/thumbnail?token=%s", this.getURLRoot(this.getVoxeetSdkInstance()), fileId, pageNumber, this.getInternalJwtToken(this.getVoxeetSdkInstance()));
    }

    public Promise<FilePresentation> convertFile(final @NonNull File file) {
        return new Promise<FilePresentation>(new PromiseSolver<FilePresentation>(){

            @Override
            public void onCall(final @NonNull Solver<FilePresentation> solver) {
                final String uuid = UUID.randomUUID().toString();
                String appended_name = uuid + file.getName();
                RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
                MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)appended_name, (RequestBody)requestFile);
                ((ISdkFilePresentationRService)FilePresentationService.this.getService()).convertFile(requestFile, body).enqueue((Callback)new Callback<ResponseBody>(){

                    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                        if (response.isSuccessful()) {
                            FilePresentationService.this.mCacheSolvers.put(uuid, solver);
                        } else {
                            solver.reject(HttpException.throwResponse(response));
                        }
                    }

                    public void onFailure(Call<ResponseBody> call, Throwable e) {
                        Log.d((String)TAG, (String)("onError: " + e));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @NonNull
    public Promise<FilePresentation> startPresentation(@NonNull FilePresentationConverted body) {
        return this.startPresentation(body, 0);
    }

    @NonNull
    public Promise<FilePresentation> startPresentation(final @NonNull FilePresentationConverted body, final int position) {
        return new Promise<FilePresentation>(new PromiseSolver<FilePresentation>(){

            @Override
            public void onCall(@NonNull Solver<FilePresentation> solver) {
                ISdkFilePresentationRService.FilePresentationId body_sent = new ISdkFilePresentationRService.FilePresentationId(body.fileId, body.name, position, body.nbImageConverted);
                FilePresentationService.this.consumeInternalCall(solver, body.fileId, FilePresentationService.this.mCacheStartedSolvers, FilePresentationService.this.internalCall((Call<ResponseBody>)((ISdkFilePresentationRService)FilePresentationService.this.getService()).startFilePresentation(FilePresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }

    @NonNull
    public Promise<FilePresentation> stopPresentation(final @NonNull String fileId) {
        return new Promise<FilePresentation>(new PromiseSolver<FilePresentation>(){

            @Override
            public void onCall(@NonNull Solver<FilePresentation> solver) {
                ISdkFilePresentationRService.FilePresentationId body_sent = new ISdkFilePresentationRService.FilePresentationId(fileId);
                FilePresentationService.this.consumeInternalCall(solver, fileId, FilePresentationService.this.mCacheStoppedSolvers, FilePresentationService.this.internalCall((Call<ResponseBody>)((ISdkFilePresentationRService)FilePresentationService.this.getService()).startFilePresentation(FilePresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }

    @NonNull
    public Promise<FilePresentation> updatePresentation(final @NonNull String fileId, final int position) {
        return new Promise<FilePresentation>(new PromiseSolver<FilePresentation>(){

            @Override
            public void onCall(@NonNull Solver<FilePresentation> solver) {
                ISdkFilePresentationRService.FilePresentationId body_sent = new ISdkFilePresentationRService.FilePresentationId(fileId, position);
                FilePresentationService.this.consumeInternalCall(solver, fileId, FilePresentationService.this.mCacheUpdatedSolvers, FilePresentationService.this.internalCall((Call<ResponseBody>)((ISdkFilePresentationRService)FilePresentationService.this.getService()).startFilePresentation(FilePresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }

    @Nullable
    private String findSolverFor(@NonNull String name) {
        for (String value : this.mCacheSolvers.keySet()) {
            if (name.indexOf(value) != 0) continue;
            return value;
        }
        return null;
    }

    @NonNull
    private FilePresentation getPresentationInformation(@NonNull String key) {
        for (FilePresentation information : this.presentations) {
            if (!key.equals(information.key)) continue;
            return information;
        }
        return new FilePresentation(key, "");
    }
}

