/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.network.endpoints.ISdkConferenceRService;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.conference.promises.SendBroadcastMessagePromise;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import eu.codlab.simplepromise.Promise;

@Annotate
public class CommandService
extends AbstractVoxeetService<ISdkConferenceRService> {
    private ConferenceSdkObservableProvider mConferenceObservableProvider = new ConferenceSdkObservableProvider();

    @NoDocumentation
    public CommandService(@NonNull VoxeetSdk instance) {
        super(instance, new ServiceProviderHolder.Builder().setRetrofit(instance.getRetrofit()).setService(ISdkConferenceRService.class).setEventBus(instance.getEventBus()).setClient(instance.getClient()).build());
        this.mConferenceObservableProvider.setRetrofitInstantiatedProvider((ISdkConferenceRService)this.getService());
    }

    @NonNull
    public Promise<Boolean> sendMessage(@NonNull String conferenceId, @NonNull String message) {
        return new SendBroadcastMessagePromise(VoxeetSdk.conference(), VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, VoxeetSdk.conference().getConferenceInformation(conferenceId), this.getEventBus(), conferenceId, message).createPromise();
    }
}

