/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.authent.token.RefreshTokenCallback;
import com.voxeet.log.endpoints.LogEndpoints;
import com.voxeet.log.factory.LogFactory;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetEnvironmentHolder;
import com.voxeet.sdk.core.VoxeetHttp;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.AudioService;
import com.voxeet.sdk.core.services.ChatService;
import com.voxeet.sdk.core.services.CommandService;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.FilePresentationService;
import com.voxeet.sdk.core.services.LocalStatsService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.RecordingService;
import com.voxeet.sdk.core.services.ScreenShareService;
import com.voxeet.sdk.core.services.SessionService;
import com.voxeet.sdk.core.services.VideoPresentationService;
import com.voxeet.sdk.core.services.authenticate.WebSocketState;
import com.voxeet.sdk.events.sdk.SocketStateChangeEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.exceptions.VoxeetSentry;
import com.voxeet.sdk.factories.VoxeetIntentFactory;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import com.voxeet.sdk.utils.AndroidManifest;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Validate;
import com.voxeet.sdk.utils.converter.JacksonConverterFactory;
import eu.codlab.simplepromise.Promise;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.EventBusException;
import retrofit2.Converter;
import retrofit2.Retrofit;

@Annotate
public final class VoxeetSdk {
    private static final String TAG = VoxeetSdk.class.getSimpleName();
    private static final long DEFAULT_TIMEOUT_MS = 60000L;
    private static Context CurrentApplication = null;
    private static VoxeetSdk CurrentInstance;
    private VoxeetHttp _voxeet_http;
    private Context _application_context;
    private EventBus _event_bus;
    private AbstractVoxeetEnvironmentHolder _voxeet_environment_holder;
    private HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> _services;
    private VoxeetSentry voxeetSentry;

    @NoDocumentation
    protected static void setInstance(@NonNull VoxeetSdk sdk) {
        CurrentInstance = sdk;
        Validate.hasInternetPermissions(sdk.getApplicationContext(), true);
        VoxeetPreferences.init(sdk.getApplicationContext(), sdk.getVoxeetEnvironmentHolder());
    }

    @Nullable
    public static VoxeetSdk instance() {
        return CurrentInstance;
    }

    public static void setApplication(@NonNull Context application) {
        CurrentApplication = application;
    }

    public static synchronized void initialize(@NonNull String appId, @NonNull String password) {
        if (null == CurrentInstance) {
            VoxeetSdk sdk = new VoxeetSdk(CurrentApplication, appId, password, null, null, new VoxeetEnvironmentHolder(CurrentApplication), false);
            VoxeetSdk.setInstance(sdk);
        } else {
            Log.d((String)TAG, (String)"initialize: Instance already started !");
        }
    }

    public static synchronized void initialize(@NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken) {
        if (null == CurrentInstance) {
            VoxeetSdk sdk = new VoxeetSdk(CurrentApplication, null, null, accessToken, refreshToken, new VoxeetEnvironmentHolder(CurrentApplication), false);
            VoxeetSdk.setInstance(sdk);
        } else {
            Log.d((String)TAG, (String)"initialize: Instance already started !");
        }
    }

    private VoxeetSdk(@NonNull Context application_context, @Nullable String appId, @Nullable String password, @Nullable String tokenAccess, @Nullable RefreshTokenCallback tokenRefresh, @NonNull AbstractVoxeetEnvironmentHolder holder, boolean debug) {
        this.initExceptionIfOk(application_context);
        Retrofit retrofit = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl("https://report.voxeet.com").build();
        LogEndpoints endpoint = (LogEndpoints)retrofit.create(LogEndpoints.class);
        LogFactory.instance.init(endpoint);
        this._application_context = application_context;
        this._event_bus = EventBus.getDefault();
        Promise.setHandler(new Handler(Looper.getMainLooper()));
        Log.d((String)"VoxeetSDK", (String)("VoxeetSdk: version := " + holder.getVersionName()));
        this._voxeet_environment_holder = holder;
        VoxeetHttp.Builder builder = new VoxeetHttp.Builder().setApplication(application_context).setVoxeetSDK(this).setServerUrl(this._voxeet_environment_holder.getServerUrl()).setServerPort(this._voxeet_environment_holder.getServerPort()).setAppId(appId).setPassword(password).setTokenAccess(tokenAccess).setTokenRefresh(tokenRefresh).setVoxeetServiceListener(new VoxeetHttp.VoxeetServiceListener(){

            @Override
            public void onIdentifySuccess(VoxeetHttp provider) {
                VoxeetSdk.session().connectSocket(provider);
            }

            @Override
            public void onIdentifyError(String error) {
                if (null == error) {
                    error = "identfify error";
                }
                VoxeetSdk.this._event_bus.post((Object)new SocketStateChangeEvent(WebSocketState.CLOSED));
            }

            @Override
            public void onNetworkError(UnknownHostException error) {
                VoxeetSdk.this._event_bus.post((Object)new SocketStateChangeEvent(WebSocketState.CLOSED));
            }
        }).setDebug(debug);
        this._voxeet_http = builder.build();
        this._services = new HashMap();
        VoxeetPreferences.init(this.getApplicationContext(), this.getVoxeetEnvironmentHolder());
        this.initServices();
    }

    @NoDocumentation
    @Nullable
    public static ChatService chat() {
        if (null == VoxeetSdk.instance()) {
            return null;
        }
        return VoxeetSdk.instance().getServiceForKlass(ChatService.class);
    }

    @Nullable
    public static ConferenceService conference() {
        if (null == VoxeetSdk.instance()) {
            return null;
        }
        return VoxeetSdk.instance().getServiceForKlass(ConferenceService.class);
    }

    @Nullable
    public static MediaDeviceService mediaDevice() {
        if (null == VoxeetSdk.instance()) {
            return null;
        }
        return VoxeetSdk.instance().getServiceForKlass(MediaDeviceService.class);
    }

    @Nullable
    public static ScreenShareService screenShare() {
        if (null == VoxeetSdk.instance()) {
            return null;
        }
        return VoxeetSdk.instance().getServiceForKlass(ScreenShareService.class);
    }

    @Nullable
    public static SessionService session() {
        if (null == VoxeetSdk.instance()) {
            return null;
        }
        return VoxeetSdk.instance().getServiceForKlass(SessionService.class);
    }

    @Nullable
    public static FilePresentationService filePresentation() {
        if (null == VoxeetSdk.instance()) {
            return null;
        }
        return VoxeetSdk.instance().getServiceForKlass(FilePresentationService.class);
    }

    @Nullable
    public static VideoPresentationService videoPresentation() {
        if (null == VoxeetSdk.instance()) {
            return null;
        }
        return VoxeetSdk.instance().getServiceForKlass(VideoPresentationService.class);
    }

    @Nullable
    public static AudioService audio() {
        if (null == VoxeetSdk.instance()) {
            return null;
        }
        return VoxeetSdk.instance().getServiceForKlass(AudioService.class);
    }

    @Nullable
    public static RecordingService recording() {
        if (null == VoxeetSdk.instance()) {
            return null;
        }
        return VoxeetSdk.instance().getServiceForKlass(RecordingService.class);
    }

    @Nullable
    public static CommandService command() {
        if (null == VoxeetSdk.instance()) {
            return null;
        }
        return VoxeetSdk.instance().getServiceForKlass(CommandService.class);
    }

    @Nullable
    public static LocalStatsService localStats() {
        if (null == VoxeetSdk.instance()) {
            return null;
        }
        return VoxeetSdk.instance().getServiceForKlass(LocalStatsService.class);
    }

    @NoDocumentation
    public static boolean manageRemoteMessage(@NonNull Context context, @NonNull Map<String, String> remoteMessage) {
        if (remoteMessage.containsKey("NotifType")) {
            String notificationType = remoteMessage.get("NotifType");
            if (null == notificationType || TextUtils.isEmpty((CharSequence)notificationType)) {
                notificationType = "";
            }
            switch (notificationType) {
                case "1": {
                    String voxeet_default_incoming = AndroidManifest.readMetadata(context, "voxeet_incoming_class", VoxeetPreferences.getDefaultActivity());
                    Intent intent = VoxeetIntentFactory.buildFrom(context, voxeet_default_incoming, remoteMessage);
                    if (intent == null) break;
                    context.startActivity(intent);
                    break;
                }
                case "5": {
                    String conferenceId = "";
                    if (remoteMessage.containsKey("ConfId")) {
                        conferenceId = remoteMessage.get("ConfId");
                    }
                    if (null == conferenceId || TextUtils.isEmpty((CharSequence)conferenceId)) {
                        conferenceId = "";
                    }
                    EventBus.getDefault().post((Object)new ConferenceDestroyedPush(conferenceId));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @NoDocumentation
    public Retrofit getRetrofit() {
        return this._voxeet_http.getRetrofit();
    }

    @NoDocumentation
    public OkHttpClient getClient() {
        return this._voxeet_http.getClient();
    }

    @NoDocumentation
    public Context getApplicationContext() {
        return this._application_context;
    }

    @NoDocumentation
    public AbstractVoxeetEnvironmentHolder getVoxeetEnvironmentHolder() {
        return this._voxeet_environment_holder;
    }

    @NonNull
    public EventBus getEventBus() {
        return this._event_bus;
    }

    public boolean register(@Nullable Object subscriber) {
        try {
            EventBus eventBus = this.getEventBus();
            if (null != subscriber && !eventBus.isRegistered(subscriber)) {
                eventBus.register(subscriber);
            }
        }
        catch (EventBusException error) {
            error.printStackTrace();
            return false;
        }
        return true;
    }

    public void unregister(@NonNull Object subscriber) {
        try {
            if (this.getEventBus().isRegistered(subscriber)) {
                this.getEventBus().unregister(subscriber);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NoDocumentation
    protected HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> getServices() {
        return this._services;
    }

    @NoDocumentation
    protected VoxeetHttp getVoxeetHttp() {
        return this._voxeet_http;
    }

    private void initExceptionIfOk(@NonNull Context application_context) {
        Log.d((String)TAG, (String)"initExceptionIfOk: checking for exception to log internally");
        this.voxeetSentry = new VoxeetSentry(application_context);
        ExceptionManager.register(this.voxeetSentry);
        Log.d((String)TAG, (String)"initExceptionIfOk: finished to try implementing error management");
    }

    private <T extends AbstractVoxeetService> T getServiceForKlass(Class<T> klass) {
        AbstractVoxeetService service = null;
        for (Class<? extends AbstractVoxeetService> next : this._services.keySet()) {
            AbstractVoxeetService item = this._services.get(next);
            if (!klass.isInstance(item)) continue;
            service = item;
        }
        if (service == null) {
            Log.d((String)TAG, (String)(klass.getSimpleName() + " not found in the list of services"));
        }
        return (T)service;
    }

    private void initServices() {
        this.getServices().put(ConferenceService.class, new ConferenceService(this, 60000L));
        this.getServices().put(SessionService.class, new SessionService(this));
        this.getServices().put(FilePresentationService.class, new FilePresentationService(this));
        this.getServices().put(VideoPresentationService.class, new VideoPresentationService(this));
        this.getServices().put(AudioService.class, new AudioService(this));
        this.getServices().put(ScreenShareService.class, new ScreenShareService(this));
        this.getServices().put(MediaDeviceService.class, new MediaDeviceService(this));
        this.getServices().put(LocalStatsService.class, new LocalStatsService(this));
        this.getServices().put(ChatService.class, new ChatService(this));
        this.getServices().put(CommandService.class, new CommandService(this));
        this.getServices().put(RecordingService.class, new RecordingService(this));
    }
}

