package com.voxeet.sdk.models.v1;

import android.support.annotation.NonNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.voxeet.sdk.json.UserInfo;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Participant {

    @JsonProperty("participant_id")
    private String participantId;

    private String externalId;

    @JsonProperty("conference_id")
    private String conferenceId;

    @JsonProperty("device_type")
    private String deviceType;

    private String status;

    private String name;

    private String avatarUrl;

    public String getParticipantId() {
        return participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public String getExternalId() {
        return externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAvatarUrl() {
        return avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    @NonNull
    public UserInfo getUserInfos() {
        return new UserInfo(getName(), getExternalId(), getAvatarUrl());
    }
}
