package com.voxeet.sdk.models.v1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class MeetingAttributes {

    private String msg;

    @JsonProperty("attended_participant")
    private List<String> attendedParticipants;

    @JsonProperty("conference_duration")
    private long duration;

    @JsonProperty("conference_id")
    private String conferenceId;

    @JsonProperty("nb_recording_step")
    private int recordingStep;

    @JsonProperty("file_url")
    private String fileUrl;

    @JsonProperty("thumbnail_url")
    private String thumbnailUrl;

    @JsonProperty("file_type")
    private String fileType;

    @JsonProperty("file_size")
    private String fileSize;

    @JsonProperty("file_name")
    private String fileName;

    @JsonProperty("user_fullname")
    private String username;

    @JsonProperty("waveform_data")
    private AudioJson waveform;

    public AudioJson getWaveform() {
        return waveform;
    }

    public void setWaveform(AudioJson waveform) {
        this.waveform = waveform;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public int getRecordingStep() {
        return recordingStep;
    }

    public void setRecordingStep(int recordingStep) {
        this.recordingStep = recordingStep;
    }

    public List<String> getAttendedParticipants() {
        List<String> list = new ArrayList<>();
        list.addAll(attendedParticipants);
        return list;
    }

    public void setAttendedParticipants(List<String> attendedParticipants) {
        this.attendedParticipants = attendedParticipants;
    }

    public long getDuration() {
        return duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileSize() {
        return fileSize;
    }

    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}
