package com.voxeet.sdk.media.peer;

import android.support.annotation.Nullable;

/**
 * Describe the possible Peer Connection Types
 */
public enum Type{
    OFFER(0),
    ANSWER(1),
    CANDIDATES(2);

    private int mValue;

    private Type(int value){
        mValue = value;
    }

    public int value(){
        return mValue;
    }

    public static Type fromString(@Nullable String type) {
        if(null != type) {
            switch(type) {
                case "offer": return Type.OFFER;
                case "answer": return Type.ANSWER;
                //default = null
            }
        }

        return null;
    }
}