package com.voxeet.sdk.media.peer;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.SdpCandidate;

import java.util.Collections;

/**
 * Deprecated behaviour : the current is waiting on the main thread !
 * working on implementing a non blocking wait behaviour
 * <p>
 * first iteration : generic instead of Object
 */
public class PendingPeerOperation implements PendingPeerCallback {
    private static String TAG = PendingPeerOperation.class.getSimpleName();
    private Handler handle = new Handler(Looper.getMainLooper());

    private String mPeer;
    private Type mType;

    private SdpDescription mValue;
    @Nullable
    private PendingPeerCallback mListener;

    public PendingPeerOperation(Type type, String peer) {
        mType = type;
        mPeer = peer;
    }

    public void waitOperation(long timeout) throws MediaEngineException {
        Log.d(TAG, "waitOperation: " + Looper.myLooper());
        handle.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (mListener != null && mValue == null) {
                    onMessage(null);
                    Log.d(TAG, "Timeout reached while waiting for operation: %s for mPeer: %s".format(mType.name(), mPeer));
                }
            }
        }, timeout);
    }

    public boolean tryUnlock(@NonNull Type type, @NonNull String peer, @Nullable SdpDescription value) {
        Log.d(TAG, "tryUnlock: " + Looper.myLooper());
        Log.d(TAG, "tryUnlock: " + type + " " + peer + " " + value.type + " " + value.sdp);
        if (this.mType != type || !this.mPeer.equals(peer)) {
            return false;
        }

        mValue = value;

        SdpMessage message = new SdpMessage(value, Collections.<SdpCandidate>emptyList());
        Log.d(TAG, "unlocked: " + type + " " + peer + " " + value.type + " " + value.sdp);
        onMessage(message);

        return true;
    }


    public void setListener(@NonNull PendingPeerCallback listener) {
        mListener = listener;
    }

    private boolean equals(PendingPeerOperation operation) {
        if (operation == this) {
            return true;
        }

        Log.d(TAG, "equals: " + operation.mPeer + " " + mPeer + " " + mType + " " + operation.mType);
        if (this.mType == operation.mType && this.mPeer == operation.mPeer) {
            return true;
        }

        return false;
    }

    @Override
    public boolean equals(Object value) {
        Log.d(TAG, "equals: " + value);
        if (value != null) {
            if (value instanceof PendingPeerOperation) {
                return equals((PendingPeerOperation) value);
            }
        }

        return false;
    }

    @Override
    public int hashCode() {
        return (mType.value() * 397) ^ (mPeer != null ? mPeer.hashCode() : 0);
    }

    @Override
    public void onMessage(@Nullable SdpMessage message) {
        if (null != message) {
            Log.d(TAG, "onMessage: " + message.getDescription().type + " " + message.getDescription());
        } else {
            Log.d(TAG, "onMessage: null");
        }

        final PendingPeerCallback callback = mListener;

        if (null != callback) {
            callback.onMessage(message);
        }
    }
}
