package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

/**
 * Event fired when a specific video should be stopped
 */
@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.VIDEO_PRESENTATION_STOPPED)
public class VideoPresentationStopped extends Event {

    /**
     * Represent the key of the current video to manage
     */
    public String key;

    /**
     * The Conference that is managing this video
     */
    public String conferenceId;

    /**
     * The creator of the request
     */
    public String userId;

    @Override
    public String getType() {
        return EventNames.VIDEO_PRESENTATION_STOPPED;
    }
}
