package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.RECORDING_STATUS_UPDATE)
public class RecordingStatusUpdateEvent extends Event {

    @JsonProperty("conference_id")
    public String conferenceId;

    @JsonProperty("user_id")
    public String userId;

    @JsonProperty("recording_status")
    public String recordingStatus;

    @JsonProperty("start_record_timestamp")
    public long timeStamp;

    @Override
    public String getType() {
        return EventNames.RECORDING_STATUS_UPDATE;
    }
}
