package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.NoDocumentation;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.FILE_PRESENTATION_STOPPED)
public class FilePresentationStopped extends Event {

    public String conferenceId;

    public String userId;
    public String fileId;

    @NoDocumentation
    public FilePresentationStopped() {

    }

    @NoDocumentation
    public FilePresentationStopped(String conferenceId,
                                   String userId,
                                   String fileId) {
        this();

        this.conferenceId = conferenceId;
        this.userId = userId;
        this.fileId = fileId;
    }

    @Override
    public String getType() {
        return EventNames.FILE_PRESENTATION_STOPPED;
    }

}
