package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.CONFERENCE_DESTROYED)
public class ConferenceDestroyedPush extends Event {

    public String conferenceId;

    public String status;

    public ConferenceDestroyedPush() {

    }

    public ConferenceDestroyedPush(String conferenceId) {
        this.conferenceId = conferenceId;
        this.status = "";
    }

    @Override
    public String getType() {
        return EventNames.CONFERENCE_DESTROYED;
    }
}
