package com.voxeet.sdk.events.v2;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Event fired when a Status for a given User has been changed in the Conference
 *
 * - join
 * - invited
 * - leaving
 * - left
 * - error
 * - etc...
 *
 * See the User's Status for more information
 */
@Annotate
@FromSDK
public class UserUpdatedEvent extends SuccessEvent {

    /**
     * The User holding this event
     */
    @NonNull
    public User user;

    /**
     * The underlying Conference instance
     */
    @NoDocumentation
    @Nullable
    public Conference conference;

    @NoDocumentation
    public UserUpdatedEvent(@NonNull Conference conference,
                            @NonNull User user) {
        this.user = user;
        this.conference = conference;
    }
}
