package com.voxeet.sdk.events.v2;

import android.support.annotation.NonNull;

import com.voxeet.android.media.MediaStream;
import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Event fired when a new Stream is available for a given User in a specified Conference
 */
@Annotate
@FromSDK
public class StreamAddedEvent extends SuccessEvent {

    /**
     * The User holding this event
     */
    @NonNull
    public User user;

    /**
     * The underlying Conference instance
     */
    @NoDocumentation
    @NonNull
    public Conference conference;

    /**
     * The MediaStream which fired the event
     */
    @NonNull
    public MediaStream mediaStream;

    @NoDocumentation
    public StreamAddedEvent(@NonNull Conference conference,
                            @NonNull User user,
                            @NonNull MediaStream mediaStream) {
        this.user = user;
        this.conference = conference;
        this.mediaStream = mediaStream;
    }
}
