package com.voxeet.sdk.events.sdk;

import android.support.annotation.NonNull;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;

@Annotate
@FromSDK
public class ConferenceUserCallDeclinedEvent extends SuccessEvent {

    @NonNull
    public String conferenceId;

    @NonNull
    public String userId;

    @NonNull
    public ConferenceUserStatus status;

    public ConferenceUserCallDeclinedEvent(@NonNull String conferenceId,
                                           @NonNull String userId,
                                           @NonNull ConferenceUserStatus status) {
        this.conferenceId = conferenceId;
        this.userId = userId;
        this.status = status;
    }

}
